<?php
if (!defined('ABSPATH')) {
	exit;
}

add_filter('query_vars', function ($query_vars) {
	return array_merge($query_vars, array('listing', 'region', 'itinerary', 'event', 'challenge', 'dmo', 'form-block'));
});

function get_page_data($template) {
	global $post;
	if (!isset($post)) return $template;

	$type = get_post_meta($post->ID, 'itinerator_page_type', true);
	if (empty($type)) return $template;

	$page_slug = get_post_meta($post->ID, 'itinerator_page_slug', true);
	$slug = empty($page_slug) ? get_query_var($type) : $page_slug;
	// if the page has a itinerator_page_type but no slug then we need to redirect.
	if (empty($slug)) return get_404_template();

	$data = query_itin_api(pluralize_type($type) . '/' . $slug);
	if (!isset($data)) return get_404_template();

	$jm = new JsonMapper();
	$jm->bStrictNullTypes = false;
	$jm->postMappingMethod = "postMapping";
	$class = "\Itinerator\Templates\\" . ucfirst($type);
	set_query_var('querydata', $jm->map($data, new $class()));
	set_query_var('itinPageType', $type);
	add_filter('wpseo_title', 'itin_page_title', 15);
	set_seo_data();
	return $template;
}

add_action('template_include', 'get_page_data');
