<?php
if (!defined('ABSPATH')) {
	exit;
}

function array_any(array $array, callable $fn) {
	foreach ($array as $value) {
		if ($fn($value)) {
			return true;
		}
	}
	return false;
}

function page_url() {
	$s = $_SERVER;
	return "$s[WP_HOME]$s[REQUEST_URI]";
}

function is_editor_serverside_render() {
	$isRequest = is_request();
	return ($isRequest && !empty($_REQUEST['context']) && 'edit' === $_REQUEST['context']);
}

function is_request() {
	return defined('REST_REQUEST') && REST_REQUEST;
}

function is_frontend() {
	$isRequest = is_request();
	$isGBEditor = is_editor_serverside_render();
	$isWPBlock = $isGBEditor && get_post_type() == 'wp_block';
	$isAdmin = is_admin();
	$is_frontend = !$isWPBlock && ((!$isAdmin && !$isRequest) || $isGBEditor);
	return $is_frontend;
}

function get_and_include_template($attr, $slug, $name = null) {
	$attr['itinPageType'] = get_query_var('itinPageType');
	$template_name = isset($name) ? $name : $attr['itinPageType'];
	$itinerator_template_loader = new Itinerator\Vendors\TemplateLoader();
	$template = $itinerator_template_loader->get_template_part($slug, $template_name, false);
	ob_start();
	include($template);
	return ob_get_clean();
}

function get_block_args($custom_args) {
	$default_args = array(
		// Enqueue blocks.style.build.css on both frontend & backend.
		'style'         => 'itinerator-cgb-style-css',
		// Enqueue blocks.build.js in the editor only.
		'editor_script' => 'itinerator-cgb-block-js',
		// Enqueue blocks.editor.build.css in the editor only.
		'editor_style'  => 'itinerator-cgb-block-editor-css',
		'template' => [
			array('core/heading', array('level' => 5, 'content' => 'Role')),
		],
	);
	return array_merge($default_args, $custom_args);
}

function limit_string_length($string, $length = 150) {
	return strlen($string) > $length ? substr($string, 0, $length) . "..." : $string;
}

function get_block_attributes($block) {
	$attJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/' . $block . '.json');
	return json_decode($attJson, true);
}

function get_itin_pages($type = null) {
	$args = array(
		'post_type' => 'page',
		'post_status' => 'any',
		'posts_per_page' => -1,
		'meta_query' => array(
			'relation' => 'AND',
			array(
				'key' => 'itinerator_page_type',
				'compare' => 'EXISTS',
			),
			array(
				'key' => 'itinerator_page_type',
				'value' => $type ?? '',
				'compare' => isset($type) ? '=' : '!='
			),
			array(
				'relation' => 'OR',
				array(
					'key' => 'itinerator_page_slug',
					'compare' => 'NOT EXISTS',
				),
				array(
					'key' => 'itinerator_page_slug',
					'value' => '',
				)
			)
		),
	);
	return get_posts($args);
}

function pluralize_type($type) {
	switch ($type) {
		case "itinerary":
			return 'itineraries';
		case 'region':
		case 'listing':
		case 'event':
		case 'challenge':
		case 'dmo':
    case 'form-block' :
			return $type . 's';
		default:
			return false;
	}
}


function build_filter($params) {
	return  http_build_query(
		array("filter" => $params)
	);
}

function prefix_number($quantity, $word, $prefix_number) {
	if (!$prefix_number) return $word;
	return $quantity . ' ' . $word;
}

function pluralize($quantity, $singular, $prefix_number = false, $plural = null) {
	if ($quantity == 1 || !strlen($singular)) return prefix_number($quantity, $singular, $prefix_number);
	if ($plural !== null) return prefix_number($quantity, $plural, $prefix_number);

	$last_letter = strtolower($singular[strlen($singular) - 1]);
	$word = '';
	switch ($last_letter) {
		case 'y':
			$word = substr($singular, 0, -1) . 'ies';
		case 's':
			$word = $singular . 'es';
		default:
			$word =  $singular . 's';
	}
	return prefix_number($quantity, $word, $prefix_number);
}

