<?php
if (!defined('ABSPATH')) {
	exit;
}

function get_rewrites() {
	$posts = get_itin_pages();
	$res = array_map(function ($post) {
		$post_id = $post->ID;
		$type = get_post_meta($post_id, 'itinerator_page_type', true);
		$slug = $post->post_name;
		return array(
			'regex' => '^' . $slug . '/([^/]*)/?',
			'query' => 'index.php?page_id=' . $post_id . '&' . $type . '=$matches[1]'
		);
	}, $posts);

	return $res;
}

function flush_rewrite() {
	$rewrites = get_rewrites();
	$flush = false;
	$flush = array_any($rewrites, function ($rewrite) {
		$rules = get_option('rewrite_rules');
		return !isset($rules[$rewrite['regex']]);
	});
	if ($flush) {
		global $wp_rewrite;
		$wp_rewrite->flush_rules();
	}
	return;
}

add_action('wp_loaded', 'flush_rewrite');

function insert_rewrite_rules($rules) {
	$rewrites = get_rewrites();
	$newrules = array();
	foreach ($rewrites as $rewrite) {
		$newrules[$rewrite['regex']] = $rewrite['query'];
	}
	return $newrules + $rules;
}

add_action('rewrite_rules_array', 'insert_rewrite_rules');

