<?php
if (!defined('ABSPATH')) {
	exit;
}

function post_search_results($result, $server, $request) {
	if ($request->get_route() == "/wp/v2/search" && $request->get_param("type") == "post") {
		$search = $request->get_param('search');
		$itinDataByType = query_itin_api('page_search?search=' . $search);
		$posts = get_itin_pages();
		foreach ($posts as $post) {
			$itinPageType = get_post_meta($post->ID, 'itinerator_page_type', true);
			if (empty($itinPageType)) continue;
			$data = $itinDataByType->$itinPageType;
			foreach ($data as $item) {
				array_push(
					$result->data,
					array(
						"id" => $item->id * -1,
						'title' => $item->name,
						'url' => "/" . $post->post_name . "/" . $item->slug,
						'type' => 'post',
						'subtype' => 'page'
					)
				);
			}
		}
	}
	return $result;
}

add_filter('rest_post_dispatch', 'post_search_results', 10, 3);
