<?php
if (!defined('ABSPATH')) {
  exit;
}

function add_rest_api()
{
  register_rest_route(
    'itinerator/v1',
    '/content_types/(?P<type>\S+)',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_content_types',
      'permission_callback' => '__return_true'
    )
  );
  register_rest_route(
    'itinerator/v1',
    '/tag_categories',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_tag_categories',
      'permission_callback' => '__return_true'
    )
  );
  register_rest_route(
    'itinerator/v1',
    '/tags_by_category/(?P<category>\S+)',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_tags_by_category',
      'permission_callback' => '__return_true'
    )
  );
  register_rest_route(
    'itinerator/v1',
    '/itin_pages(?:/(?P<type>\S+))?',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_itinerator_pages',
      'permission_callback' => '__return_true',
    )
  );
  register_rest_route(
    'itinerator/v1',
    '/record_list_by_type(?:/(?P<type>\S+))?',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_record_list_by_type',
      'permission_callback' => '__return_true',
    )
  );
  register_rest_route(
    'itinerator/v1',
    '/additional_listings',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_additional_listings',
      'permission_callback' => '__return_true',
    )
  );

  register_rest_route(
    'itinerator/v1',
    'dmos/itineraries',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_dmo_itineraries',
      'permission_callback' => '__return_true',
    )
  );

  register_rest_route(
    'itinerator/v1',
    '/(?P<type>\S+)',
    array(
      'methods' => WP_REST_Server::READABLE,
      'callback' => 'get_records',
      'permission_callback' => '__return_true',
    )
  );


}


function get_record_list_by_type($data)
{
  $type = $data['type'];
  $data =  query_itin_api($type . '/list');
  return $data;
}

function get_records($data)
{
  $type = $data['type'];
  $params = array(
    'parent_region_id' => $data['parent_region_id'],
    'region_id' => $data['region_id'],
  );
  $filter = http_build_query(
    array(
      "filter" => $params,
      "tagIds" => $data['tagIds'],
      "showRegions" => $data['showRegions'],
      "showListings" => $data['showListings'],
      "showDmos" => $data['showDmos'],
      "tag" => array(
        "name" => $data['tagName'],
        "category" => $data['tagCategory']
      )
    )
  );

  $res =  query_itin_api("$type?" . $filter);

  if (isset($res->error)) {
    return new WP_Error(
      'record_not_found',
      'Record Not Found',
      array('status' => 404)
    );
  }

  return $res;
}

function get_itinerator_pages($data)
{
  $type = $data['type'];
  return get_itin_pages($type);
}

function get_content_types($data)
{
  $type = $data['type'];
  $res = query_itin_api("content_types/by_class/$type");
  return $res;
}

function get_tag_categories()
{
  return query_itin_api("tags/categories");
}

function get_tags_by_category($data)
{
  $category = $data['category'];
  return query_itin_api("tags/list/$category");
}

function get_additional_listings()
{
  return query_itin_api('listings/additional');
}

function get_dmo_itineraries($data)
{
  $secret_key = $data['secret_key'];

  // if (empty($secret_key)) {
  //     return new WP_Error('missing_secret_key', 'Secret Key is required.', array('status' => 400));
  // }

  $query_param = ['secret_key' => $secret_key];

  $response = query_itin_api('dmos/itineraries', false, $query_param);

  // if ($response === false) {
  //     return new WP_Error('query_failure', 'query_itin_api function failed.', array('status' => 500));
  // }

  return $response;
}

add_action('rest_api_init', 'add_rest_api');
