<?php
if (!defined('ABSPATH')) {
    exit;
}

function itinerator_clear_cache_field() {
    $cache_enabled = get_option('itinerator_cache_enabled', 'no'); // Changed default to 'no'
    ?>
    <div class="cache-controls" style="margin-bottom: 15px;">
        <label class="cache-toggle">
            <input type="checkbox"
                   id="itinerator_cache_enabled"
                   name="itinerator_cache_enabled"
                   value="yes"
                   <?php checked($cache_enabled, 'yes'); ?>>
            Enable API Response Caching
        </label>
        <p class="description">When enabled, API responses will be cached for 24 hours to improve performance.</p>
    </div>

    <button type="button" id="clear-itin-cache" class="button button-secondary" <?php echo $cache_enabled === 'no' ? 'disabled' : ''; ?>>
        Clear Itinerator Cache
    </button>
    <span id="cache-clear-status" style="margin-left: 10px; display: none;"></span>
    <p class="description">Click to clear all cached API responses.</p>

    <script>
    jQuery(document).ready(function($) {
        const cacheToggle = $('#itinerator_cache_enabled');
        const clearButton = $('#clear-itin-cache');

        cacheToggle.on('change', function() {
            const isEnabled = $(this).is(':checked');
            clearButton.prop('disabled', !isEnabled);

            // Save the setting via AJAX
            $.post(ajaxurl, {
                action: 'toggle_itin_cache',
                enabled: isEnabled ? 'yes' : 'no',
                _ajax_nonce: '<?php echo wp_create_nonce("toggle_itin_cache_nonce"); ?>'
            });
        });

        $('#clear-itin-cache').on('click', function() {
            const button = $(this);
            const statusSpan = $('#cache-clear-status');

            button.prop('disabled', true);
            statusSpan.html('Clearing cache...').show();

            $.post(ajaxurl, {
                action: 'clear_itin_cache',
                _ajax_nonce: '<?php echo wp_create_nonce("clear_itin_cache_nonce"); ?>'
            })
            .done(function(response) {
                statusSpan.html(response.data.message).css('color', 'green');
            })
            .fail(function() {
                statusSpan.html('Failed to clear cache').css('color', 'red');
            })
            .always(function() {
                button.prop('disabled', !cacheToggle.is(':checked'));
                setTimeout(() => statusSpan.fadeOut(), 3000);
            });
        });
    });
    </script>
    <?php
}
