<?php
if (!defined('ABSPATH')) {
  exit;
}

function itinerator_theme_settings_field()
{
  $theme_settings = query_itin_api('/platform_extensions/by_type/CmsExtension', false, []);
  $primary_color = get_option('itinerator_primary_color', !empty($theme_settings->options->theme->primary_color) ? $theme_settings->options->theme->primary_color : '#007bff');
  $secondary_color = get_option('itinerator_secondary_color', !empty($theme_settings->options->theme->secondary_color) ? $theme_settings->options->theme->secondary_color : '#6c757d');
  $light_color = get_option('itinerator_light_color', !empty($theme_settings->options->theme->light_color) ? $theme_settings->options->theme->light_color : '#f8f9fa');
  $dark_color = get_option('itinerator_dark_color', !empty($theme_settings->options->theme->dark_color) ? $theme_settings->options->theme->dark_color : '#343a40');
  $text_color = get_option('itinerator_text_color', !empty($theme_settings->options->theme->text_color) ? $theme_settings->options->theme->text_color : $primary_color);
  $heading_color = get_option('itinerator_heading_color', !empty($theme_settings->options->theme->heading_color) ? $theme_settings->options->theme->heading_color : $primary_color);
  $link_color = get_option('itinerator_link_color', !empty($theme_settings->options->theme->link_color) ? $theme_settings->options->theme->link_color : $primary_color);
  $btn_background = get_option('itinerator_btn_background', !empty($theme_settings->options->theme->btn_background) ? $theme_settings->options->theme->btn_background : $primary_color);
  $btn_border_color = get_option('itinerator_btn_border_color', !empty($theme_settings->options->theme->btn_border_color) ? $theme_settings->options->theme->btn_border_color : $primary_color);
  $btn_link_color = get_option('itinerator_btn_link_color', !empty($theme_settings->options->theme->btn_link_color) ? $theme_settings->options->theme->btn_link_color : $light_color);
  $btn_border_radius = get_option('itinerator_btn_border_radius', !empty($theme_settings->options->theme->btn_border_radius) ? $theme_settings->options->theme->btn_border_radius : '5px');
  $btn_border_width = get_option('itinerator_btn_border_width', !empty($theme_settings->options->theme->btn_border_width) ? $theme_settings->options->theme->btn_border_width : '1px');
  $btn_border_color = get_option('itinerator_btn_border_color', !empty($theme_settings->options->theme->btn_border_color) ? $theme_settings->options->theme->btn_border_color : $primary_color);
?>
  <table class="form-table">
    <tr>
      <th scope="row"><?php _e('Primary Color', 'my-textdomain'); ?></th>
      <td>
        <input type="text" name="itinerator_primary_color" value="<?php echo esc_attr($primary_color); ?>" class="regular-text color-field color-picker" data-default-color="<?php echo esc_attr($primary_color); ?>" />
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Secondary Color', 'my-textdomain'); ?></th>
      <td>
        <input type="text" name="itinerator_secondary_color" value="<?php echo esc_attr($secondary_color); ?>" class="regular-text color-field color-picker" data-default-color="<?php echo esc_attr($secondary_color); ?>" />
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Light Color', 'my-textdomain'); ?></th>
      <td>
        <input type="text" name="itinerator_light_color" value="<?php echo esc_attr($light_color); ?>" class="regular-text color-field color-picker" data-default-color="<?php echo esc_attr($light_color); ?>" />
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Dark Color', 'my-textdomain'); ?></th>
      <td>
        <input type="text" name="itinerator_dark_color" value="<?php echo esc_attr($dark_color); ?>" class="regular-text color-field color-picker" data-default-color="<?php echo esc_attr($dark_color); ?>" />
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Text Color', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_text_color" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($text_color, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($text_color, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($text_color, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($text_color, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Heading Color', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_heading_color" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($heading_color, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($heading_color, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($heading_color, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($heading_color, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Link Color', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_link_color" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($link_color, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($link_color, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($link_color, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($link_color, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Button Background', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_btn_background" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($btn_background, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($btn_background, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($btn_background, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($btn_background, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Button Border Color', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_btn_border_color" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($btn_border_color, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($btn_border_color, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($btn_border_color, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($btn_border_color, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Button Link Color', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_btn_link_color" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($btn_link_color, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($btn_link_color, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($btn_link_color, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($btn_link_color, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Button Border Radius', 'my-textdomain'); ?></th>
      <td>
        <input type="text" name="itinerator_btn_border_radius" value="<?php echo esc_attr($btn_border_radius); ?>" class="regular-text" />
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Button Border Width', 'my-textdomain'); ?></th>
      <td>
        <input type="text" name="itinerator_btn_border_width" value="<?php echo esc_attr($btn_border_width); ?>" class="regular-text" />
      </td>
    </tr>
    <tr>
      <th scope="row"><?php _e('Button Border Color', 'my-textdomain'); ?></th>
      <td>
        <select name="itinerator_btn_border_color" class="regular-text color-field">
          <option value="<?php echo esc_attr($primary_color); ?>" <?php selected($btn_border_color, $primary_color); ?>>Primary</option>
          <option value="<?php echo esc_attr($secondary_color); ?>" <?php selected($btn_border_color, $secondary_color); ?>>Secondary</option>
          <option value="<?php echo esc_attr($light_color); ?>" <?php selected($btn_border_color, $light_color); ?>>Light</option>
          <option value="<?php echo esc_attr($dark_color); ?>" <?php selected($btn_border_color, $dark_color); ?>>Dark</option>
        </select>
      </td>
    </tr>
  </table>
  <p>These settings can be edited in the Itinerator Admin interface and will be updated next time you save this page. Please edit theme in your platform settings <a href="https://admin.itinerator.ca/" target="_blank">here</a></p>
<?php
}
add_action('admin_enqueue_scripts', 'itinerator_admin_scripts');
function itinerator_admin_scripts()
{
  wp_enqueue_style('wp-color-picker');
  wp_enqueue_script('wp-color-picker');
  wp_add_inline_script('wp-color-picker', '
    jQuery(document).ready(function($){
      $(".color-field.color-picker").wpColorPicker();
    });
  ');
}
