<?php
if (!defined('ABSPATH')) {
  exit;
}
require_once 'fields/fields.php';

function itinerator_settings()
{
  add_settings_section(
    'default',
    "",
    '',
    'itinerator-plugin'
  );

  // API key field
  add_settings_field(
    'itinerator_api_key_field',
    __('Platform API Key', 'my-textdomain'),
    'itinerator_api_key_field',
    'itinerator-plugin',
  );

  // DMO/Partner API key field
  add_settings_field(
    'itinerator_dmo_partner_key_field',
    __('DMO/Partner API Key', 'my-textdomain'),
    'itinerator_dmo_partner_key_field',
    'itinerator-plugin',
  );

  // Google Maps key
  add_settings_field(
    'itinerator_google_api_key_field',
    __('Google Maps API Key', 'my-textdomain'),
    'itinerator_google_api_key_field',
    'itinerator-plugin',
  );
  add_settings_field(
    'itinerator_google_map_id_field',
    __('Google Maps Map Id', 'my-textdomain'),
    'itinerator_google_map_id_field',
    'itinerator-plugin',
  );

  add_settings_field(
    'itinerator_clear_cache_field',
    __('Cache Settings', 'my-textdomain'),
    'itinerator_clear_cache_field',
    'itinerator-plugin',
    'default'
  );

  add_settings_field(
    'itinerator_theme_settings_field',
    __('Theme Settings', 'my-textdomain'),
    'itinerator_theme_settings_field',
    'itinerator-plugin',
    'default'
  );

  register_setting('itinerator-plugin', 'itinerator_api_key_field');
  register_setting('itinerator-plugin', 'itinerator_google_api_key_field');
  register_setting('itinerator-plugin', 'itinerator_google_map_id_field');
  register_setting('itinerator-plugin', 'itinerator_dmo_partner_key_field');

  register_setting('itinerator-plugin', 'itinerator_primary_color');
  register_setting('itinerator-plugin', 'itinerator_secondary_color');
  register_setting('itinerator-plugin', 'itinerator_light_color');
  register_setting('itinerator-plugin', 'itinerator_dark_color');
  register_setting('itinerator-plugin', 'itinerator_text_color');
  register_setting('itinerator-plugin', 'itinerator_heading_color');
  register_setting('itinerator-plugin', 'itinerator_link_color');
  register_setting('itinerator-plugin', 'itinerator_btn_background');
  register_setting('itinerator-plugin', 'itinerator_btn_border_color');
  register_setting('itinerator-plugin', 'itinerator_btn_link_color');
  register_setting('itinerator-plugin', 'itinerator_btn_border_radius');
  register_setting('itinerator-plugin', 'itinerator_btn_border_width');
  register_setting('itinerator-plugin', 'itinerator_btn_border_color');
  register_setting('itinerator-plugin', 'itinerator_cache_enabled');

  if (isset($_POST['option_page']) && $_POST['option_page'] === 'itinerator-plugin') {
    error_log('Settings saved!');
  }
}


add_action('admin_init', 'itinerator_settings');
