<?php
if (!defined('ABSPATH')) {
  exit;
}

function shared_block_assets()
{ // phpcs:ignore

  // Get the primary color from the options table, or use a default value
  $primary_color = get_option('itinerator_primary_color', '#007bff');
  $secondary_color = get_option('itinerator_secondary_color', '#6c757d');
  $light_color = get_option('itinerator_light_color', '#f8f9fa');
  $dark_color = get_option('itinerator_dark_color', '#343a40');
  $text_color = get_option('itinerator_text_color', $primary_color);
  $heading_color = get_option('itinerator_heading_color', $primary_color);
  $link_color = get_option('itinerator_link_color', $primary_color);
  $btn_background = get_option('itinerator_btn_background', $primary_color);
  $btn_border_color = get_option('itinerator_btn_border_color', $primary_color);
  $btn_link_color = get_option('itinerator_btn_link_color', $light_color);
  $border_radius = get_option('itinerator_btn_border_radius', '5px');
  $border_width = get_option('itinerator_border_width', '1px');
  $border_color = get_option('itinerator_border_color', $primary_color);

  // Create the SCSS variable
  $color_variables_scss = ":root {
      --itin-primary-color: $primary_color;
      --itin-secondary-color: $secondary_color;
      --itin-light-color: $light_color;
      --itin-dark-color: $dark_color;
      --itin-text-color: $text_color;
      --itin-heading-color: $heading_color;
      --itin-link-color: $link_color;
      --itin-btn-background: $btn_background;
      --itin-btn-border-color: $btn_border_color;
      --itin-btn-link-color: $btn_link_color;
      --itin-border-radius: $border_radius;
      --itin-border-width: $border_width;
      --itin-border-color: $border_color;

    }";

  wp_enqueue_style('dashicons');

  wp_register_script(
    'google_maps_api', // Handle.
    'https://maps.googleapis.com/maps/api/js?key=' . get_option('itinerator_google_api_key_field') . '&v=beta',
    [],
    null,
    true
  );
  // wp_script_add_data('google_maps_api', 'defer', true);
  // wp_enqueue_script('google_maps_api');

  wp_register_style(
    'itinerator-vendors', // Handle.
    ITINERATOR_PLUGIN_URL . 'dist/vendors.build.css',
    is_admin() ? array('wp-block-editor') : null,
    null
  );
  wp_enqueue_style('itinerator-vendors');

  // Register block styles for frontend
  wp_register_style(
    'itinerator-cgb-style-css', // Handle.
    ITINERATOR_PLUGIN_URL . 'dist/blocks.style.build.css',
    is_admin() ? array('wp-block-editor') : null,
    null
  );
  wp_enqueue_style('itinerator-cgb-style-css');

  wp_add_inline_style('itinerator-cgb-style-css', $color_variables_scss); // Add the SCSS variable inline

  wp_register_script(
    'itinerator-js', // Handle.
    ITINERATOR_PLUGIN_URL . 'dist/itinerator.build.js',
    array('wp-blocks', 'wp-i18n', 'wp-element', 'jquery'),
    null,
    false
  );
  // wp_enqueue_script('itinerator-js');

  wp_localize_script(
    'itinerator-js',
    'itineratorGlobal', // Array containing dynamic data for a JS Global.
    [
      'pluginDirPath' => ITINERATOR_PLUGIN_DIR,
      'pluginDirUrl'  => ITINERATOR_PLUGIN_URL,
      'googleMapsApiKey' => ITIN_GOOGLE_MAPS_API_KEY,
      'googleMapsMapId' => ITIN_GOOGLE_MAPS_MAP_ID,
      'dmoPartnerApiKey' => DMO_PARTNER_API_KEY,
      'itinBootstrap' => ITIN_BOOTSTRAP,
      'isPlatformAPIKeyValid' => ITIN_IS_PLATFORM_API_KEY_VALID,
      'isDMOAPIKeyValid' => ITIN_IS_DMO_API_KEY_VALID
      // Add more data here that you want to access from `itineratorGlobal` object.
    ]
  );
  require_once __DIR__ . '/registrations.php';

}

add_action('init', 'shared_block_assets');
