<?php
if (!defined('ABSPATH')) {
	exit;
}

/**
 * Uncomment the next line of code to disable sitemap caching.
 * - For development environments and debugging only.
 * - All other scenarios, follow the "Manual Sitemap Update" instructions in the Yoast documentation:
 *   - https://yoast.com/help/sitemap-does-not-update/#manual
 */
// add_filter("wpseo_enable_xml_sitemap_transient_caching", "__return_false");

function format_mod_date($date_string) {
	$last_mod = date_create($date_string);
	return date_format($last_mod, DATE_W3C);
}

function itinerator_sitemap_post_types() {
	return array("page");
}


/**
 * Add itinerator-sitemap.xml to Yoast sitemap index
 */
function itinerator_sitemap_index($sitemap_index) {
	$sitemap_url = home_url("itinerator-sitemap.xml");
	$sitemap_date = format_mod_date(query_itin_api('sitemap_updated_at'));
	$custom_sitemap = <<<SITEMAP_INDEX_ENTRY
<sitemap>
	<loc>%s</loc>
	<lastmod>%s</lastmod>
</sitemap>
SITEMAP_INDEX_ENTRY;
	$sitemap_index .= sprintf($custom_sitemap, $sitemap_url, $sitemap_date);
	return $sitemap_index;
}
add_filter("wpseo_sitemap_index", "itinerator_sitemap_index");

/**
 * Register itinerator sitemap with Yoast
 */
function itinerator_sitemap_register() {
	global $wpseo_sitemaps;
	if (isset($wpseo_sitemaps) && !empty($wpseo_sitemaps)) {
		$wpseo_sitemaps->register_sitemap("itinerator", "itinerator_sitemap_generate");
	}
}
add_action("init", "itinerator_sitemap_register");


function init_do_sitemap_actions() {
	add_action('wp_seo_do_sitemap_itinerator', 'itinerator_sitemap_generate');
}
add_action("init", "init_do_Sitemap_actions");
/**
 * Generate itinerator sitemap XML body
 */
function itinerator_sitemap_generate() {
	global $wpseo_sitemaps;
	$urls_string = itinerator_sitemap_urls();
	$sitemap_body = <<<SITEMAP_BODY
<urlset
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
	xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd http://www.google.com/schemas/sitemap-image/1.1 http://www.google.com/schemas/sitemap-image/1.1/sitemap-image.xsd"
	xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
%s
</urlset>
SITEMAP_BODY;
	$sitemap = sprintf($sitemap_body, $urls_string);
	$wpseo_sitemaps->set_sitemap($sitemap);
}


function itinerator_sitemap_urls() {
	global $wpseo_sitemaps;
	$urls = array();
	$itinDataByType = array(
		'listing' => query_itin_api('listings'),
		'region' => query_itin_api('regions')
	);
	$posts = get_itin_pages();
	foreach ($posts as $post) {
		$itinPageType = get_post_meta($post->ID, 'itinerator_page_type', true);
		if (empty($itinPageType)) continue;
		$data = $itinDataByType[$itinPageType];
		foreach ($data as $item) {
			$last_mod = date_create($item->updated_at);
			$url = array(
				"mod" => date_format($last_mod, DATE_W3C),  # <lastmod></lastmod>
				"loc" => get_permalink($post) . $item->slug,  # <loc></loc>
			);
			// Transform url array to sitemap `<url></url>` schema format
			if (isset($item->hero)) {
				$url["images"] = array(
					array(  # <image:image></image:image>
						"src" =>  $item->hero->url,  # <image:loc></image:loc>
						"title" => $item->name,  # <image:title></image:title>
						"alt" => $item->hero->caption,  # <image:caption></image:caption>
					),
				);
			}
			$urls[] = $wpseo_sitemaps->renderer->sitemap_url($url);
		}
	}
	return implode("\n", $urls);
}
