<?php
if (!defined('ABSPATH')) {
	exit;
}

add_action('init', 'create_itinerator_taxonomies');


function create_itinerator_taxonomies() {
	$types = ['listing', 'region', 'itinerary'];

	foreach ($types as $type) {
		$plural = pluralize_type($type);
		$upper_plural = ucfirst($plural);
		$upper_type = ucfirst($type);

		$labels = array(
			'name' => _x($upper_plural, 'taxonomy general name'),
			'singular_name' => _x($upper_type, 'taxonomy singular name'),
			'search_items' => __('Search ' . $upper_plural),
			'popular_items' => __("Popular " . $upper_plural),
			'all_items' => __("All " . $upper_plural),
			'parent_item' => null,
			'parent_item_colon' => null,
			'edit_item' => null,
			'update_item' => null,
			'add_new_item' => null,
			'new_item_name' => null,
			'separate_items_with_commas' => __('Separate ' . $plural . ' with commas'),
			'add_or_remove_items' => __('Add or remove ' . $plural),
			'choose_from_most_used' => __('Choose from the most used ' . $plural),
			'menu_name' => __('Itinerator ' . $upper_plural)
		);
		register_taxonomy('itin-' . $plural, 'post', array(
			'capabilities' => array(
				'manage_terms' => '',
				'edit_terms' => 'edit_posts',
				'delete_terms' => '',
				'assign_terms' => 'edit_posts'
			),
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'public' => false,
			'show_in_rest' => true,
			'show_admin_column' => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var' => true,
		));
	}
}

add_action('wp', function () {
	if (!wp_next_scheduled('itin_taxonomy_cron_hook')) {
		wp_schedule_event(time(), 'twicedaily', 'itin_taxonomy_cron_hook');
	}
});


add_action('itin_taxonomy_cron_hook', 'itin_create_taxonomy_terms');

function itin_create_taxonomy_terms() {
	$types = ['listings', 'regions', 'itineraries'];
	foreach ($types as $type) {
		$taxonomy_name = 'itin-' . $type;
		$records = query_itin_api($type . '/list');
		foreach ($records as $record) {
			$term = get_term_by('slug', $record->id, $taxonomy_name);
			if (!$term) {
				wp_insert_term($record->name, $taxonomy_name, array("slug" => $record->id));
			}
		}
		$record_ids = array_map(function ($record) {
			return $record->id;
		}, $records);
		$terms = get_terms(['taxonomy' => $taxonomy_name, 'hide_empty' => false]);
		foreach ($terms as $term) {
			if (!in_array($term->slug, $record_ids)) {
				wp_delete_term($term->id, $taxonomy_name);
			}
		}
	}
}
