<?php
if (!defined('ABSPATH')) {
	exit;
}

function itin_page_title($title = null)
{
	$data = get_query_var('querydata');
	$title = $data->name;
	return $title;
}

function itin_schema_webpage($data)
{
	$url =  page_url();
	$data['@id'] = $url . "#webpage";
	$data['url'] = $url;
	$data['name'] = itin_page_title();
	$data['breadcrumb']['@id'] = $url . "#breadcrumb";
	$data['potentialAction'][0]['target'] = $url;
	return $data;
}

function itin_remove_breadcrumbs($pieces, $context)
{
	return \array_filter($pieces, function ($piece) {
		return !$piece instanceof \Yoast\WP\SEO\Generators\Schema\Breadcrumb;
	});
}

function itin_meta_image($presentation)
{
	global $post;
	if (isset($post)) {
		$data = get_query_var('querydata');
		$meta_image = $data->meta_image ?? null;
		if (isset($meta_image) && !empty($meta_image)) {
			$presentation->open_graph_images = [
				[
					'url' => $meta_image->url,
					'width' => $meta_image->width,
					'height' => $meta_image->height,
					'type' => $meta_image->type,
					'alt' => "test me"
				]
			];
		}
	}
	return $presentation;
}

function itin_page_description($description)
{
	$data = get_query_var('querydata');
	return $data->description ?? $description;
}

function set_seo_data()
{
	//Yoast needs to be installed for this
	if (in_array('plugin-directory/plugin-file.php', apply_filters('active_plugins', get_option('active_plugins')))) {
		add_filter('wpseo_opengraph_title', 'itin_page_title');
		add_filter('wpseo_opengraph_desc', 'itin_page_description');
		add_filter('wpseo_opengraph_url', 'page_url');
		add_filter('wpseo_schema_webpage', 'itin_schema_webpage');
		add_filter('wpseo_schema_graph_pieces', 'itin_remove_breadcrumbs', 11, 2);
		add_filter('wpseo_frontend_presentation', 'itin_meta_image', 30);
	}
}
