import { __ } from "@wordpress/i18n";
import { registerBlockType } from "@wordpress/blocks";
import { Icon } from "../assets";
import { startCase } from "lodash";

// Get block arrays from JSON
const blockData = require('../attributes/block-registration.json');
const platformBlocks = blockData.blockTypes.platformBlocks;
const dmoBlocks = blockData.blockTypes.dmoBlocks;
const { isPlatformAPIKeyValid, isDMOAPIKeyValid } = itineratorGlobal;


export class ItineratorBlock {
  constructor(name, options) {
    this.name = name;
    this.blockName = `itinerator/${name}`;
    this.options = options;
    this.register();
  }
  register() {

    if (isPlatformAPIKeyValid) {
      if (platformBlocks.includes(this.name)) {
        registerBlockType(this.blockName, {
          apiVersion: 2,
          title: __(startCase(this.name)),
          icon: Icon,
          category: "itinerator-blocks",
          keywords: [__("Itinerator")],
          example: {},
          attributes: {},
          save: () => {
            return null; // See PHP side. This block is rendered on PHP.
          },
          ...this.options,
        });
      }

    }

    if (isDMOAPIKeyValid) {
      if (dmoBlocks.includes(this.name)) {
        return registerBlockType(this.blockName, {
          apiVersion: 2,
          title: __(startCase(this.name)),
          icon: Icon,
          category: "itinerator-blocks",
          keywords: [__("Itinerator")],
          example: {},
          attributes: {},
          save: () => {
            return null; // See PHP side. This block is rendered on PHP.
          },
          ...this.options,
        });
      }
    }

  }

}

