import Flickity from "react-flickity-component";
import { useItinPageMeta } from "../hooks";
import { flickity_options } from "../constants";
import { __ } from "@wordpress/i18n";
import { ItineratorBlock } from "./ItineratorBlock";
import attributes from "../attributes/carousel.json";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { Edit, OptionsPanel } from "./common";
import { useItinSample } from "./store";

new ItineratorBlock("carousel", {
  attributes,
  supports: {
    align: true,
    customClassName: true,
  },
  edit: (props) => (
    <Edit {...props}>
      <Sidebar />
      <Display />
    </Edit>
  ),
});

const Sidebar = () => (
  <InspectorControls key="settings">
    <OptionsPanel />
  </InspectorControls>
);

const Display = () => {
  const { itinPageType } = useItinPageMeta();
  const { sample, loading } = useItinSample(itinPageType);

  const blockProps = useBlockProps({
    className: `itin itinerator-carousel ${attributes.align ? `align${attributes.align}` : ''} ${attributes.customClassName ? `${attributes.customClassName}` : ''}`,
  });


  if (loading) return null
  const { carousel_images = [] } = sample || {}
  return (
    <div {...blockProps}>
      <Flickity options={flickity_options}>
        {carousel_images.map(({ url }) => (
          <img key={url} src={url} className={'col-4'} />
        ))}
      </Flickity>
    </div>
  );
};
