import { __ } from "@wordpress/i18n";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { Edit, OptionsPanel, useEditContext, ToggleControls } from "./common";
import attributes from "../attributes/challenge.json";
import { ItineratorBlock } from "./ItineratorBlock";
import { useItinPageMeta } from "../hooks";
import { useItinSample } from "./store";
import { formatEventTimeDates } from "../helpers";

new ItineratorBlock("challenge", {
	attributes,
  supports: {
    align: true,
    customClassName: true,
  },
	edit: (props) => (
		<Edit {...props}>
			<Sidebar />
			<Display />
		</Edit>
	),
});

const Sidebar = () => {
	return (
		<InspectorControls>
			<OptionsPanel>
      <ToggleControls />

      </OptionsPanel>
		</InspectorControls>
	);
};
const Display = () => {
	const { itinPageType } = useItinPageMeta();
	const { sample, loading } = useItinSample(itinPageType);
  const { attributes } = useEditContext();
  const { showName, showDescription, showLocation, showDates, } = attributes;
	const blockProps = useBlockProps({
		className: `itin itinerator-event ${attributes.align ? `align${attributes.align}` : ''} ${attributes.customClassName ? `${attributes.customClassName}` : ''}`,
	});
	if (loading) return null;
	return (
    <div {...blockProps}>
      <div className="container-fluid">
          <div
            key={sample.id}
            className={`challenge-row row searchable-item mb-4 ${sample.slug} ${sample.tags.map((t) => `tag-id-${t.tag_id}`).join(" ")}`}
          >
            <div className="col">
              <div className="content">
                {showName && sample.name && <h2>{sample.name}</h2>}
                {showLocation && sample.target_name && <h3>{sample.target_name}</h3>}
                {showDates && sample.rewards.map((reward) => (
                  <div key={reward.id}>{reward.date_string}</div>
                ))}
                {showDescription && sample.description && (
                  <div
                    dangerouslySetInnerHTML={{
                      __html: sample.description,
                    }}
                  ></div>
                )}
              </div>
            </div>
          </div>
      </div>
    </div>
  );
};
