import { useEditContext } from "./Edit";
import { useItinPageMeta, useTagCategories } from "../../hooks";
import { Fragment } from "@wordpress/element";
import { ToggleControl } from "./ToggleControls";

export const FilterRecordsRegion = () => {
  const { attributes, setAttributes } = useEditContext();
  const { filterRecordsByRegion } = attributes;
  const { itinPageType } = useItinPageMeta();

  // return null if not placed on an itinPageType (e.g. region, itinerary, event, challenge. )
  if (!['region', 'itinerary', 'listing'].includes(itinPageType)) return null;

  return (
    <Fragment>
      <ToggleControl
        attr="filterRecordsByRegion"
        label="Filter by Region"
        help="Enable this option to filter records based on the region associated with the page this block is on. Currently only works on a region, itinerary or listing page."
      />
    </Fragment>
  );
};
