import { SelectControl } from "@wordpress/components";
import { useEffect } from "react";
import { useItinPages } from "../../hooks";
import { useEditContext } from "./Edit";
import { startCase } from "lodash";

const useLinkedPageOptions = (linkedPageId, setPageId, type) => {
  const pages = useItinPages(type);
  const default_page_id = !!pages.length && pages[0].ID;
  useEffect(() => {
    if (!!default_page_id && !linkedPageId) {
      setPageId(default_page_id.toString());
    }
  }, [default_page_id, linkedPageId]);
  return pages.map(({ ID, post_title }) => ({
    value: ID,
    label: post_title,
  }));
};

export const LinkedPageSelect = ({ type, keyName = "linkedPageId" }) => {
  const { attributes, setAttributes } = useEditContext();
  const linkedPageId = attributes[keyName];
  const handleSetId = (linkedPageId) =>
    setAttributes({ [keyName]: linkedPageId });
  const page_options = useLinkedPageOptions(linkedPageId, handleSetId, type);
  return (
    <SelectControl
      label={`Linking ${startCase(type)} Page`}
      value={linkedPageId}
      onChange={handleSetId}
      options={page_options}
      required
    />
  );
};
