import { useEditContext } from "./Edit";

export const ListingCard = ({ listing }) => {
  const { attributes } = useEditContext();
  const { showImage, showName, showDescription } = attributes;

  function getColumnClasses(columns) {
    switch (columns) {
      case "1":
        return '';
      case "2":
        return 'col-md-6';
      case "3":
        return 'col-md-4';
      case "4":
        return 'col-md-3';
      default:
        return 'col-md-4';
    }
  }

  return (
    <div
      key={listing.id}
      className={`itinerator-listing col-12 ${getColumnClasses(attributes.columns)} mb-4`}
    >
      <div className="card h-100 p-0">
        {showImage && (
          <div className="card-img-top listing-image-container">
            {listing.hero ? (
              <img src={listing.hero.url} className="img-fluid rounded-top listing-image" alt={listing.hero.caption} />
            ) : (
              <div className="d-flex align-items-center justify-content-center img-fluid rounded-top  listing-image listing-image-empty">
                <span className="text-muted">No image available</span>
              </div>
            )}
          </div>
        )}
        <div className="card-body listing-content">
          {showName && listing.name && <h4 className="card-title listing-name mb-0">{listing.name}</h4>}

          {listing.short_description && attributes.showDescription && <p className="card-text listing-description">{listing.short_description}</p>}
          {!listing.short_description && attributes.showDescription && listing.description && <p className="card-text listing-description">{listing.description}</p>}
        </div>
      </div>
    </div>
  );
};
