import { groupBy, map } from "lodash";
import { Fragment } from "@wordpress/element";
import { useEditContext } from "./Edit";

export const ListingsDirectory = ({ records }) => {
  const { attributes } = useEditContext();
  const { columns, showCity, showName } = attributes;
  const groupedListings = groupBy(records, ({ name }) => name[0].toUpperCase());
  return (
    <Fragment>
      {map(groupedListings, (listings, char) => (
        <div key={char} className={`col-${12 / columns}`}>
          <div className="listings-letter">{char}</div>
          {listings.map((listing) => (
            <div
              key={listing.id}
              className={`itinerator-listing searchable-item ${listing.region_slug}`}
            >
              {showName && (
                <div className="listing-name">
                  <p>{listing.name}</p>
                </div>
              )}
              {showCity && (
                <div className="listing-address">{listing.city}</div>
              )}
            </div>
          ))}
        </div>
      ))}
    </Fragment>
  );
};
