import { PanelRow, SelectControl } from "@wordpress/components";
import { useEditContext } from "./Edit";
import { useItinPageMeta, useTagCategories } from "../../hooks";
import { Fragment, useEffect } from "@wordpress/element";
import { ToggleControl } from "./ToggleControls";

export const TagCategoryControl = () => {
  const { attributes, setAttributes } = useEditContext();
  const { matchRecordsByTagCategory } = attributes;
  const { itinPageType } = useItinPageMeta();
  useEffect(() => {
    if (!matchRecordsByTagCategory) {
      setAttributes({ tagCategory: "" });
    }
  }, [matchRecordsByTagCategory]);
  if (!itinPageType) return null;

  return (
    <Fragment>
      <ToggleControl
      attr="matchRecordsByTagCategory"
      help="When enabled, any tags added to the region or itinerary page that this block is placed on will be used to match and display relevant listings."
       />
      {matchRecordsByTagCategory && <TagCategorySelect />}
    </Fragment>
  );
};

const TagCategorySelect = () => {
  const { attributes, setAttributes } = useEditContext();
  const { tagCategory } = attributes;
  const { defaultCategory, options } = useTagCategories();

  useEffect(() => {
    if (!tagCategory && defaultCategory !== null) {
      setAttributes({ tagCategory: defaultCategory.value });
    } else if (!tagCategory && options.length > 0) {
      setAttributes({ tagCategory: options[0].value });
    }
  }, [defaultCategory, tagCategory, options]);

  // console.log(tagCategory);

  return (
    <PanelRow>
      <SelectControl
        label="Category to Match"
        options={options}
        value={tagCategory}
        onChange={(tagCategory) => setAttributes({ tagCategory })}
      />
    </PanelRow>
  );
};
