import { startCase } from "lodash";
import { Fragment } from "@wordpress/element";
import {
  PanelRow,
  ToggleControl as WPToggleControl,
} from "@wordpress/components";
import { useEditContext } from "./Edit";

export const ToggleControls = ({ custom_attributes }) => {
  const { attributes } = useEditContext();
  const toggle_attributes = Object.keys(custom_attributes || attributes).filter(
    (attr) => typeof attributes[attr] === "boolean" && attr !== 'matchRecordsByTagCategory' && attr !== 'filterRecordsByRegion'
  );

  return (
    <Fragment>
      {toggle_attributes.map((attr) => (
        <ToggleControl key={attr} attr={attr} />
      ))}
    </Fragment>
  );
};

export const ToggleControl = ({ attr, help, label }) => {
  const { attributes, setAttributes } = useEditContext();
  const value = attributes[attr];
  const toggleLabel = label || startCase(attr);
  return (
    <PanelRow>
      <WPToggleControl
        label={toggleLabel  + "?"}
        checked={value}
        onChange={(val) => setAttributes({ [attr]: val })}
        help={help}
      />
    </PanelRow>
  );
};
