import {
  BaseControl,
  PanelRow,
  ColorPicker as WPColorPicker,
} from "@wordpress/components";
import { useAttribute } from "../../../hooks";

const getColorString = ({ rgb: { r, g, b, a } }) => `rgba(${r},${g},${b},${a})`;

export const ColorPicker = ({ attr, ...props }) => {
  const [color, setColor, label] = useAttribute(attr);
  const handleChange = (color) => setColor(getColorString(color));
  return (
    <PanelRow className="itin-color-picker">
      <BaseControl label={label}>
        <WPColorPicker
          color={color}
          onChangeComplete={handleChange}
          {...props}
        />
      </BaseControl>
    </PanelRow>
  );
};
