import {
  BaseControl,
  PanelRow,
  FontSizePicker as WPFontSizePicker,
} from "@wordpress/components";

import { useAttribute } from "../../../hooks";

export const FontSizePicker = ({ attr, ...props }) => {
  const [size, setSize, name] = useAttribute(attr);
  return (
    <PanelRow className="itin-fontsize-picker">
      <BaseControl label={name}>
        <WPFontSizePicker
          value={size}
          onChange={setSize}
          fallbackFontSize="18px"
          {...props}
        />
      </BaseControl>
    </PanelRow>
  );
};
