import { __experimentalNumberControl as WPNumberControl } from "@wordpress/components";
import { useAttribute } from "../../../hooks";
import styled from "@emotion/styled";

const UnstyledNumberPicker = ({ attr, ...props }) => {
  const [number, setNumber, name] = useAttribute(attr);
  return (
    <NumberControl
      label={name}
      value={number}
      onChange={setNumber}
      {...props}
    />
  );
};

export const NumberControl = ({ onChange, ...props }) => {
  const handleChange = (change) => {
    onChange(change ? parseFloat(change) : change);
  };
  return <WPNumberControl onChange={handleChange} {...props} />;
};

export const NumberPicker = styled(UnstyledNumberPicker)`
  width: 100%;
`;
