import {
  BaseControl,
  __experimentalHStack as HStack,
  PanelRow,
} from "@wordpress/components";
import { useAttribute } from "../../../hooks";
import { NumberControl } from "./NumberPicker";

export const PointPicker = ({ attr }) => {
  const [point, setPoint, label] = useAttribute(attr);
  const handlePointChange = (val, index) => {
    const newPoint = [...point];
    newPoint[index] = val;
    setPoint(newPoint);
  };

  return (
    <PanelRow>
      <BaseControl label={label}>
        <HStack>
          {point.map((p, i) => (
            <NumberControl
              value={p}
              onChange={(val) => handlePointChange(val, i)}
            />
          ))}
        </HStack>
      </BaseControl>
    </PanelRow>
  );
};
