import { PanelBody, PanelRow } from "@wordpress/components";

import { ColorPicker, NumberPicker } from "../inputs";

export const BoundarySidebar = () => {
  return (
    <PanelBody title="Boundary Customization" initialOpen={false}>
      <ColorPicker attr="boundaryFillColor" disableAlpha />
      <PanelRow>
        <NumberPicker attr="boundaryFillOpacity" step={0.1} max={1} min={0} />
      </PanelRow>
      <ColorPicker attr="boundaryStrokeColor" />
      <PanelRow>
        <NumberPicker attr="boundaryStrokeWeight" step={0.1} />
      </PanelRow>
      <PanelRow>
        <NumberPicker attr="boundaryStrokeOpacity" step={0.1} max={1} min={0} />
      </PanelRow>
    </PanelBody>
  );
};
