import { Marker } from "@react-google-maps/api";
import { useEditContext } from "../Edit";

export const CustomMarker = ({ label, location, ...props }) => {
  const { attributes } = useEditContext();
  const {
    markerFillColor,
    markerStrokeColor,
    markerStrokeWeight,
    markerUrl,
    markerWidth,
    markerHeight,
    markerAnchor,
    markerOrigin,
  } = attributes;

  const scaledSize = new google.maps.Size(markerWidth, markerHeight);
  const getPoint = (point) => {
    if (!!point.filter((p) => !!p).length) {
      return new google.maps.Point(point[0], point[1]);
    }
  };
  const anchor = getPoint(markerAnchor);
  const origin = getPoint(markerOrigin);
  const icon = !markerUrl
    ? {
        path: "M12,11.5A2.5,2.5 0 0,1 9.5,9A2.5,2.5 0 0,1 12,6.5A2.5,2.5 0 0,1 14.5,9A2.5,2.5 0 0,1 12,11.5M12,2A7,7 0 0,0 5,9C5,14.25 12,22 12,22C12,22 19,14.25 19,9A7,7 0 0,0 12,2Z",
        anchor: new google.maps.Point(12, 17),
        fillOpacity: 1,
        fillColor: markerFillColor,
        strokeWeight: markerStrokeWeight,
        strokeColor: markerStrokeColor,
        scale: 2,
      }
    : { url: markerUrl, scaledSize, anchor, origin };

  return (
    <Marker
      options={{
        location_slug: location.slug,
        location_id: location.id,
        location_type: location.type,
        location_name: location.name,
      }}
      title={location.name}
      icon={icon}
      {...props}
    />
  );
};;;
