import { Polygon } from "@react-google-maps/api";
import { useState } from "@wordpress/element";
import { useEditContext } from "../Edit";

export const CustomPolygon = (props) => {
  const {
    attributes: {
      boundaryFillColor,
      boundaryFillOpacity,
      boundaryStrokeColor,
      boundaryStrokeWeight,
      boundaryStrokeOpacity,
    },
  } = useEditContext();
  const [hover, setHover] = useState(false);
  const getOpacity = (baseOpacity) => {
    if (!hover) return baseOpacity;
    return Math.min(baseOpacity + 0.2, 1);
  };
  const options = {
    fillColor: boundaryFillColor,
    strokeWeight: boundaryStrokeWeight,
    strokeColor: boundaryStrokeColor,
    fillOpacity: getOpacity(boundaryFillOpacity),
    strokeOpacity: boundaryStrokeOpacity,
  };
  return (
    <Polygon
      options={options}
      {...props}
      onMouseOut={() => setHover(false)}
      onMouseOver={() => setHover(true)}
    />
  );
};
