import { GoogleMap } from "@react-google-maps/api";
import { forwardRef, useEffect, useRef, useState } from "@wordpress/element";
import { useLocation, useLinkedPage } from "../../../hooks";
import { Location } from "./Location";
const { googleMapsMapId } = itineratorGlobal;

export const Map = forwardRef((_, mapRef) => {
  const linkedListingPage = useLinkedPage();
  const linkedRegionPage = useLinkedPage("linkedRegionPageId");
  const boundsRef = useRef(new google.maps.LatLngBounds());
  const { locations, loading } = useLocation();
  const [activeMarkerId, setActiveMarkerId] = useState();
  const [tilesLoaded, setTilesLoaded] = useState(false);

  useEffect(() => {
    boundsRef.current = new google.maps.LatLngBounds();
  }, [locations.length]);

  if (loading) return <div>Loading...</div>;
  if (!locations || locations.length === 0) return <div>No locations found</div>;

  const getLinkedPage = (type) => {
    switch (type) {
      case "listing":
        return linkedListingPage;
      case "region":
        return linkedRegionPage;
      default:
        return null;
    }
  };

  return (
    <GoogleMap
      mapContainerClassName="itin itinerator-map"
      onLoad={(map) => {
        mapRef.current = map;
      }}
      onTilesLoaded={() => {
        setTilesLoaded(true);
      }}
      onClick={setActiveMarkerId}
      options={{
        mapTypeControl: false,
        fullscreenControl: false,
        streetViewControl: false,
        mapId: googleMapsMapId || undefined,
        gestureHandling: "cooperative",
      }}
    >
      {locations.map((location) => (
        <Location
        {...location}
        boundsRef={boundsRef}
        key={location.location.id}
        activeMarkerId={activeMarkerId}
        setActiveMarkerId={setActiveMarkerId}
        linkedPage={getLinkedPage(location.type)}
        tilesLoaded={tilesLoaded}
        />
      ))}
    </GoogleMap>
  );
});
