import {
  __experimentalHStack as HStack,
  PanelBody,
  PanelRow,
} from "@wordpress/components";
import { Fragment } from "@wordpress/element";
import { useEditContext } from "../Edit";
import { ColorPicker, NumberPicker, PointPicker, TextControl } from "../inputs";

export const MarkerSidebar = () => {
  const {
    attributes: { markerUrl },
  } = useEditContext();
  return (
    <PanelBody title="Marker Customization" initialOpen={false}>
      <TextControl label="Custom Marker Url" attr="markerUrl" />
      {markerUrl ? (
        <Fragment>
          <PanelRow>
            <HStack>
              <NumberPicker attr="markerWidth" />
              <NumberPicker attr="markerHeight" />
            </HStack>
          </PanelRow>
          <PointPicker attr="markerAnchor" />
          <PointPicker attr="markerOrigin" />
        </Fragment>
      ) : (
        <Fragment>
          <ColorPicker attr="markerFillColor" />
          <ColorPicker attr="markerStrokeColor" />
          <PanelRow>
            <NumberPicker attr="markerStrokeWeight" step={0.1} />
          </PanelRow>
        </Fragment>
      )}
      <NumberPicker attr="markerLabelOriginHeight" />
      <TextControl attr="markerLabelClass" />
    </PanelBody>
  );
};
