import { __ } from "@wordpress/i18n";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { PanelRow, SelectControl } from "@wordpress/components";
import { useItinPageMeta } from "../hooks";
import { SAMPLE_LISTING } from "../sample-data";
import attributes from "../attributes/description.json";
import { ItineratorBlock } from "./ItineratorBlock";
import { Edit, OptionsPanel, useEditContext } from "./common";

new ItineratorBlock("description", {
  attributes,
  edit: (props) => (
    <Edit {...props}>
      <Sidebar />
      <Display />
    </Edit>
  ),
});

const Sidebar = () => {
  const { attributes, setAttributes } = useEditContext();
  const { descriptionType } = attributes;
  return (
    <InspectorControls key="settings">
      <OptionsPanel>
        <PanelRow>
          <SelectControl
            label="Type"
            value={descriptionType}
            onChange={(type) => setAttributes({ descriptionType: type })}
            options={[
              { value: "full", label: "Full Description" },
              { value: "short", label: "Short Description" },
            ]}
          />
        </PanelRow>
      </OptionsPanel>
    </InspectorControls>
  );
};

const Display = () => {
  const { attributes } = useEditContext();
  const { descriptionType } = attributes;
  const { itinPageType } = useItinPageMeta();
  const { description, short_description } = SAMPLE_LISTING;
  const blockProps = useBlockProps({
    className: `col-12 text-center description itinerator-${itinPageType}`,
  });
  return (
    <div {...blockProps}>
      <p
        dangerouslySetInnerHTML={{
          __html: descriptionType === "full" ? description : short_description,
        }}
      />
    </div>
  );
};
