import { __ } from "@wordpress/i18n";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { Edit, OptionsPanel } from "./common";
import attributes from "../attributes/event.json";
import { ItineratorBlock } from "./ItineratorBlock";
import { useItinPageMeta } from "../hooks";
import { useItinSample } from "./store";
import { formatEventTimeDates } from "../helpers";

new ItineratorBlock("event", {
	attributes,
	edit: (props) => (
		<Edit {...props}>
			<Sidebar />
			<Display />
		</Edit>
	),
});

const Sidebar = () => {
	return (
		<InspectorControls>
			<OptionsPanel />
		</InspectorControls>
	);
};
const Display = () => {
	const { itinPageType } = useItinPageMeta();
	const { sample, loading } = useItinSample(itinPageType);
	const blockProps = useBlockProps({
		className: "itinerator-event alignfull",
	});
	if (loading) return null;
	return (
		<div {...blockProps}>
			<h3>{sample.name}</h3>
			<h4>{sample.target_name}</h4>
			{sample.event_times.map(event_time => {
				const { date_line, time_line } = formatEventTimeDates(event_time);
				return (<div>
					<p>
						<span>{date_line}</span>
						{!!time_line && " | "}
						<span>{time_line}</span>
					</p>
					{event_time.locations.map(location => (<div>{location.name}</div>))}
				</div>)
			})}
		</div>
	);
};
