import { __ } from "@wordpress/i18n";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
// import { SAMPLE_LISTING } from "../sample-data";
import { Edit, OptionsPanel, ToggleControls, useEditContext } from "./common";
import attributes from "../attributes/listing-info.json";
import { ItineratorBlock } from "./ItineratorBlock";
import { useItinSample } from "./store";
import { useItinPageMeta } from "../hooks";

new ItineratorBlock("listing-info", {
  attributes,
  edit: (props) => {
    return (
      <Edit {...props}>
        <Sidebar />
        <Display />
      </Edit>
    );
  },
});

const Sidebar = () => {
  return (
    <InspectorControls>
      <OptionsPanel>
        <ToggleControls />
      </OptionsPanel>
    </InspectorControls>
  );
};

const Display = () => {
  const { attributes } = useEditContext();
  const { itinPageType } = useItinPageMeta();
  const { sample, loading } = useItinSample(itinPageType);

  const { showImage, showAddress, showWebsite, showHours } = attributes;
  const blockProps = useBlockProps({
    className: "container itinerator-listing",
  });
  if (itinPageType !== 'listing') return <div{...blockProps}>
    {"This block is only meant to be used on Single Listing Page Types. Please remove this block or change the Page Type."}
  </div>
  if (loading) return null

  const { hero, name, operating_hours = [], full_address, website } = sample || {}
  return (
    <div {...blockProps}>
      <div className="row">
        {showImage && (
          <div className="col-6">
            <img className="card-img-top" src={hero.url} alt={name} />
          </div>
        )}
        <div className="col-6">
          {showHours && (
            <div>
              <div>
                <strong>Hours of Operation</strong>
              </div>
              <ul>
                {operating_hours.map((hour) => (
                  <li key={hour.id}>
                    {hour.day_of_week} {hour.open_time}-{hour.close_time}
                  </li>
                ))}
              </ul>
            </div>
          )}
          {showAddress && (
            <p>
              <strong>{full_address}</strong>
            </p>
          )}
          {showWebsite && (
            <a className="btn btn-primary" href={website} role="button">
              Visit Website
            </a>
          )}
        </div>
      </div>
    </div>
  );
};
