import {
  Edit,
  LinkedPageSelect,
  ListingCard,
  OptionsPanel,
  ToggleControls,
  useEditContext,
} from "./common";
import attributes from "../attributes/listings-additional.json";
import { PanelRow, SelectControl } from "@wordpress/components";
import { __ } from "@wordpress/i18n";
import {
  InspectorControls,
  RichText,
  useBlockProps,
} from "@wordpress/block-editor";
import { ItineratorBlock } from "./ItineratorBlock";
import { useAdditionalListings } from "../hooks";

new ItineratorBlock("listings-additional", {
  title: __("Additional Listings"),
  attributes,
  supports: {
    align: true,
    customClassName: true,
  },
  edit: (props) => {
    return (
      <Edit {...props}>
        <Sidebar />
        <Display />
      </Edit>
    );
  },
});

const Sidebar = () => {
  const { attributes, setAttributes } = useEditContext();
  const { columns } = attributes;
  return (
    <InspectorControls key="settings">
      <OptionsPanel>
        <LinkedPageSelect type="listing" />
        <PanelRow>
          <div style={{ minWidth: "50%" }}>
            <SelectControl
              label="Columns"
              value={columns}
              onChange={(type) => setAttributes({ columns: type })}
              options={[
                { value: "1", label: "1" },
                { value: "2", label: "2" },
                { value: "3", label: "3" },
                { value: "4", label: "4" },
              ]}
            />
          </div>
        </PanelRow>
        <ToggleControls />
      </OptionsPanel>
    </InspectorControls>
  );
};

const Display = () => {
  const { attributes, setAttributes } = useEditContext();

  const { records, loading } = useAdditionalListings();

  const blockProps = useBlockProps({
    className: `itin itinerator-listings itinerator-premium-listings ${attributes.align ? `align${attributes.align}` : ''} ${attributes.customClassName ? `${attributes.customClassName}` : ''}`,
  });
  return (
    <div {...blockProps}>
      <div className="container-fluid">
        {!records.length && !loading && "No Listings found"}

          <div className="row g-4">
            {records.map((listing) => (
            <ListingCard key={listing.id} listing={listing} />
            ))}
          </div>

      </div>
    </div>
  );
};
