import Flickity from "react-flickity-component";
import { flickity_options } from "../constants";
import {
  Edit,
  LinkedPageSelect,
  OptionsPanel,
  ToggleControls,
  useEditContext,
} from "./common";
import attributes from "../attributes/listings-featured.json";
import { __ } from "@wordpress/i18n";
import {
  InspectorControls,
  RichText,
  useBlockProps,
} from "@wordpress/block-editor";
import { ItineratorBlock } from "./ItineratorBlock";
import { useRecords } from "../hooks";

new ItineratorBlock("featured", {
  attributes,
  supports: {
    align: true,
    customClassName: true,
  },
  edit: (props) => (
    <Edit {...props}>
      <Sidebar />
      <Display />
    </Edit>
  ),
});

const Sidebar = () => {
  return (
    <InspectorControls>
      <OptionsPanel>
        <LinkedPageSelect type="listing" />
        <ToggleControls />
      </OptionsPanel>
    </InspectorControls>
  );
};

const Display = () => {
  const { attributes, setAttributes } = useEditContext();
  const { showName } = attributes;
  const { records } = useRecords("listings/featured");

  const blockProps = useBlockProps({
    className: `itin itinerator-featured-listing  ${attributes.align ? `align${attributes.align}` : ''} ${attributes.customClassName ? `${attributes.customClassName}` : ''}`,
  });

  return (
    <div {...blockProps}>
      <Flickity options={flickity_options} data-flickity='{ "wrapAround": true }'>
        {records.map((listing) => (
          <div
            key={listing.id}
            className="carousel-cell"
          >
            <img
              src={listing.hero.url}
              alt="Card Image"
              className="listing-image"
            />
            {showName && listing.name && <h4 className="card-title listing-name mb-0">{listing.name}</h4>}
          </div>
        ))}
      </Flickity>
    </div>
  );
};
