import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { Fragment, useEffect, useRef } from "@wordpress/element";
import attributes from "../attributes/map.json";
import { useItinPageMeta } from "../hooks";

import {
  Edit,
  LinkedPageSelect,
  OptionsPanel,
  TagFilters,
  ToggleControl,
  ToggleControls,
  useEditContext,
} from "./common";
import { Map } from "./common";
import { BoundarySidebar } from "./common/map/BoundarySidebar";
import { MarkerSidebar } from "./common/map/MarkerSidebar";
import { ItineratorBlock } from "./ItineratorBlock";

new ItineratorBlock("map", {
  attributes,
  edit: (props) => {
    const blockProps = useBlockProps();
    const ref = useRef();
    return (
      <Edit {...props}>
        <Sidebar />
        <div {...blockProps}>
          <Map ref={ref} />
        </div>
      </Edit>
    );
  },
});

const Sidebar = () => {
  const { attributes, setAttributes } = useEditContext();

  const {
    pageType,
    showRecordMarkers,
    showRecordBoundaries,
    showRecordLabels,
    ...otherAttributes
  } = attributes;

  const { itinPageType, itinPageSlug } = useItinPageMeta();

  useEffect(() => {
    // need to set this here so we can access it on the front end rendering.
    setAttributes({ pageType: itinPageType });
    setAttributes({ recordId: itinPageSlug });
  }, [itinPageType, itinPageSlug]);

  return (
    <InspectorControls key="settings">
      <OptionsPanel>
        {!!pageType && (
          <Fragment>
            <ToggleControl attr="showRecordMarkers" />
            <ToggleControl attr="showRecordBoundaries" />
            <ToggleControl attr="showRecordLabels" />
          </Fragment>
        )}
        {(!pageType || pageType === "region") && (
          <Fragment>
            <ToggleControls custom_attributes={otherAttributes} />
            <LinkedPageSelect type="listing" />
          </Fragment>
        )}
        <LinkedPageSelect type="region" keyName="linkedRegionPageId" />
      </OptionsPanel>
      {(!pageType || pageType === "region") && <TagFilters />}
      <MarkerSidebar />
      <BoundarySidebar />
    </InspectorControls>
  );
};
