import { useEffect } from "react";
import { __ } from "@wordpress/i18n";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { PanelRow, SelectControl } from "@wordpress/components";
import { useItinPageMeta, useTagCategories } from "../hooks";
import { SAMPLE_LISTING } from "../sample-data";
import { ItineratorBlock } from "./ItineratorBlock";
import attributes from "../attributes/tags.json";
import { Edit, OptionsPanel, useEditContext } from "./common";

new ItineratorBlock("tags", {
  attributes,
  edit: (props) => (
    <Edit {...props}>
      <Sidebar />
      <Display />
    </Edit>
  ),
});

const Sidebar = () => {
  const { attributes, setAttributes } = useEditContext();
  const { tagCategory } = attributes;
  const setTagCategory = (tagCategory) => setAttributes({ tagCategory });
  const { defaultCategory, options } = useTagCategories();

  useEffect(() => {
    if (!tagCategory && !!defaultCategory) {
      setTagCategory(defaultCategory);
    }
  }, [tagCategory, defaultCategory]);

  return (
    <InspectorControls>
      <OptionsPanel>
        <PanelRow>
          <SelectControl
            label="Tag Category"
            value={tagCategory}
            onChange={setTagCategory}
            options={options}
          />
        </PanelRow>
      </OptionsPanel>
    </InspectorControls>
  );
};

const Display = () => {
  const { attributes } = useEditContext();
  const { tags } = SAMPLE_LISTING;
  const { tagCategory } = attributes;
  const { itinPageType } = useItinPageMeta();
  const blockProps = useBlockProps({
    className: `col-12 text-center ${tagCategory} itinerator-${itinPageType}`,
  });
  return (
    <div {...blockProps}>
      <p>{tags.map((t) => t.name).join(" | ")}</p>
    </div>
  );
};
