import { __ } from "@wordpress/i18n";
import { InspectorControls, useBlockProps } from "@wordpress/block-editor";
import { Edit, OptionsPanel, ToggleControls, useEditContext } from "./common";
import { useItinPageMeta } from "../hooks";
import attributes from "../attributes/title.json";
import { ItineratorBlock } from "./ItineratorBlock";
import { useItinSample } from "./store";

new ItineratorBlock("title", {
  attributes,
  supports: {
    align: true,
    customClassName: true,
    // color: {
    //   text: true,
    //   background: false,
    //   link: false,
    //   heading: true,
    // },
  },
  edit: (props) => {
    return (
      <Edit {...props}>
        <Sidebar />
        <Display />
      </Edit>
    );
  },
});

const Sidebar = () => {
  return (
    <InspectorControls>
      <OptionsPanel>
        <ToggleControls />
      </OptionsPanel>
    </InspectorControls>
  );
};

const Display = () => {
  const { attributes } = useEditContext();
  const { showName, showImage, showSubtitle } = attributes;
  const { itinPageType } = useItinPageMeta();
  const { sample, loading } = useItinSample(itinPageType);
  const blockProps = useBlockProps({
    className: `itin itinerator-title itinerator-${itinPageType} ${attributes.align ? `align${attributes.align}` : ''} ${attributes.customClassName ? `${attributes.customClassName}` : ''}`,
  });
  if (loading) return null;
  const { name, hero, subtitle } = sample;
  return (
    <div {...blockProps}>
      <div
        className={`${itinPageType}-title ${
          showImage ? "with-image" : ""
        }`}
        style={
          showImage && !!hero ? { backgroundImage: `url(${hero.url})` } : null
        }
      >
        <div className="banner-content">
          {showName && <h1>{name}</h1>}
          {showSubtitle && <p>{subtitle ? subtitle : 'Subtitle Here'}</p>}
        </div>
      </div>
    </div>
  );
};
