import { __ } from "@wordpress/i18n";
import { startCase } from "lodash";
import dayjs from 'dayjs';

export const getWpApiPath = (path) => {
  return `/wp-json/itinerator/v1/${path}`;
};

export const pluralizeType = (type) => {
  switch (type) {
    case "itinerary":
      return "itineraries";
    case "region":
    case "dmo":
    case "listing":
    case "event":
    case "challenge":
      return `${type}s`;
    default:
      return false;
  }
};

export const initialArray = (label) => (!!label ? [{ value: "", label }] : []);

export const listToSelectOptions = (list, blank_label) => {
  return initialArray(blank_label).concat(
    list.map((item) => ({
      value: item,
      label: startCase(item),
    }))
  );
};

export const fetchRecordListByType = (type, blank_label = "None") => {
  return fetch(getWpApiPath(`record_list_by_type/${type}`))
    .then((res) => res.json())
    .then((list) =>
      initialArray(blank_label).concat(
        list.map(({ name, slug }) => ({ value: slug, label: name }))
      )
    );
};

export const getPosition = (values) => ({
  lat: parseFloat(values.lat),
  lng: parseFloat(values.lng),
});

export const formatEventTimeDates = (event_time) => {
  const { next_start, next_end, all_day } = event_time;
  const start_date = dayjs(next_start);
  const end_date = dayjs(next_end);
  const isSameDay = start_date.isSame(end_date, "day");
  const start_string = start_date.format(
    isSameDay || all_day ? "ddd, MMMM D" : "MMMM D h:mm A"
  );
  const end_string =
    !isSameDay && end_date.format(all_day ? "ddd, MMMM D" : "MMMM D h:mm A");
  const start_time_string = start_date.format("h:mm A");
  const end_time_string = end_date.format("h:mm A");
  const date_line = [start_string, end_string].filter(Boolean).join(" - ");
  const time_line =
    isSameDay && !all_day && [start_time_string, end_time_string].join(" - ");
  return { date_line, time_line };
};
