import { startCase } from "lodash";
const { pluginDirUrl } = itineratorGlobal;
function getSampleUrl(number) {
  return `${pluginDirUrl}images/sample_${number}.jpg`;
}
const names = [
  "Buckingham Palace",
  "Burj Khalifa",
  "Eiffel Tower",
  "Mont Saint-Michel",
  "Mount Rushmore",
  "St. Basil's Cathedral",
  "Sydney Opera House",
  "Taj Mahal",
];
const cities = [
  "London",
  "Dubai",
  "Paris",
  "Normandy",
  "Keystone",
  "Moscow",
  "Sydney",
  "Agra",
];
const region_slugs = [
  "united_kingdom",
  "united_arab_emirates",
  "france",
  "united_states",
  "russia",
  "australia",
  "india",
];
export const sampleListings = (count = 8) => {
  let i = 1;
  const listings = [];
  while (i <= Math.min(count, 8)) {
    listings.push({
      id: i,
      description:
        "<b>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam tincidunt nulla non rutrum aliquet. Aenean ex ipsum, vestibulum quis nisl a, iaculis iaculis elit. Suspendisse magna lorem, tristique eu lacus vel, rhoncus vulputate nunc. Duis aliquet in ante in rutrum. Ut id rutrum velit. Nam quis lorem vitae ex sagittis sodales eu ut risus. Maecenas sodales, ligula semper varius consectetur, augue enim placerat sapien, in efficitur nulla turpis et mauris. Mauris sollicitudin suscipit nisl vel suscipit.</b>\n<h2>Lorem Ipsum\n</h2>Cras id sagittis sem. Mauris luctus lectus eu eros molestie interdum. Phasellus a arcu velit. Nam et dapibus ante. Praesent vitae felis ac neque elementum finibus. Vivamus urna velit, suscipit pharetra dolor sit amet, posuere porta lectus. Etiam sodales condimentum nibh, et pretium odio ultricies quis. Morbi quis nisl ante. Nunc condimentum urna eget bibendum aliquam.\n<h2>Lorem Ipsum\n</h2>Cras blandit accumsan urna a fringilla. Ut in rhoncus arcu. Aenean viverra lorem at rutrum laoreet. Nulla mi purus, imperdiet blandit nisi a, pulvinar ullamcorper massa. Pellentesque euismod dolor et tellus tempus placerat. Integer pellentesque tincidunt tortor, aliquet aliquet justo sollicitudin nec. Vestibulum ut sem ac elit pulvinar commodo. Duis sed lorem eu lorem dapibus fermentum id in nisi. Vestibulum ac ultrices ante. Vivamus metus nunc, mattis id tellus condimentum, consectetur eleifend ante.",
      short_description:
        "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
      name: names[i - 1],
      slug: `sample-location-${i}`,
      city: cities[i - 1],
      hero: getSampleUrl(i),
      region_slug: region_slugs[i - 1],
    });
    i++;
  }
  return listings;
};

export const sampleRegions = (count = 8) => {
  let i = 1;
  const regions = [];
  while (i <= Math.min(count, 8)) {
    regions.push({
      id: i,
      description:
        "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
      name: startCase(region_slugs[i - 1]),
      slug: region_slugs[i - 1],
      hero: getSampleUrl(i),
    });
    i++;
  }
  return regions;
};

export const sampleDmos = (count = 8) => {
  const dmos = [];
  for (let i = 1; i <= count; i++) {
    dmos.push({
      id: i,
      website: `https://www.example${i}.com`,
      name: startCase(region_slugs[i - 1]),
      description: `Sample description for ${region_slugs[i - 1]}`,
      logo: {
        caption: `${region_slugs[i - 1]} Logo`,
        content_type: 'image/png',
        url: `https://example.com/${region_slugs[i - 1].toLowerCase()}-logo.png`,
      },
    });
  }
  return dmos;
};

export const SAMPLE_LISTING = {
  id: 1,
  main_type: "member",
  description:
    "<b>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam tincidunt nulla non rutrum aliquet. Aenean ex ipsum, vestibulum quis nisl a, iaculis iaculis elit. Suspendisse magna lorem, tristique eu lacus vel, rhoncus vulputate nunc. Duis aliquet in ante in rutrum. Ut id rutrum velit. Nam quis lorem vitae ex sagittis sodales eu ut risus. Maecenas sodales, ligula semper varius consectetur, augue enim placerat sapien, in efficitur nulla turpis et mauris. Mauris sollicitudin suscipit nisl vel suscipit.</b>\n<h2>Lorem Ipsum\n</h2>Cras id sagittis sem. Mauris luctus lectus eu eros molestie interdum. Phasellus a arcu velit. Nam et dapibus ante. Praesent vitae felis ac neque elementum finibus. Vivamus urna velit, suscipit pharetra dolor sit amet, posuere porta lectus. Etiam sodales condimentum nibh, et pretium odio ultricies quis. Morbi quis nisl ante. Nunc condimentum urna eget bibendum aliquam.\n<h2>Lorem Ipsum\n</h2>Cras blandit accumsan urna a fringilla. Ut in rhoncus arcu. Aenean viverra lorem at rutrum laoreet. Nulla mi purus, imperdiet blandit nisi a, pulvinar ullamcorper massa. Pellentesque euismod dolor et tellus tempus placerat. Integer pellentesque tincidunt tortor, aliquet aliquet justo sollicitudin nec. Vestibulum ut sem ac elit pulvinar commodo. Duis sed lorem eu lorem dapibus fermentum id in nisi. Vestibulum ac ultrices ante. Vivamus metus nunc, mattis id tellus condimentum, consectetur eleifend ante.",
  short_description:
    "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
  name: "Buckingham Palace",
  subtitle: "The Queen's official London residence and a working royal palace.",
  slug: "buckingham-palace",
  region_id: 1,
  region_slug: "united_kingdom",
  full_address: "12345 Sample Rd, Victoria, BC, A1B 2C3",
  street_address: "12345 Sample Rd",
  city: " Victoria",
  province: "bc",
  postal_code: "A1B 2C3",
  country: "CA",
  lat: 51.50128214079232,
  lng: -0.1418639871964362,
  geofence: [
    { lat: 51.49962670363086, lng: -0.14252066444253142 },
    { lat: 51.50116770578958, lng: -0.14416217635964568 },
    { lat: 51.50210939083666, lng: -0.14231238006448654 },
    { lat: 51.50211363031333, lng: -0.14096591113901047 },
    { lat: 51.50214914277635, lng: -0.14044288038110642 },
    { lat: 51.50201997088227, lng: -0.14014917849397568 },
    { lat: 51.50180845600079, lng: -0.140109615911006 },
    { lat: 51.501602518962486, lng: -0.1403365978488913 },
    { lat: 51.5013058691887, lng: -0.14054664834237007 },
    { lat: 51.50024783823151, lng: -0.14092836021280197 },
  ],
  google_maps_url: null,
  email: "sample@example.ca",
  phone_number: "555-555-5555",
  website: "https://thenumber.ca/",
  operating_hours: [
    {
      id: 1,
      day_of_week: "Monday",
      open_time: "8am",
      close_time: "7pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
    {
      id: 2,
      day_of_week: "Tuesday",
      open_time: "9am",
      close_time: "5pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
    {
      id: 3,
      day_of_week: "Wednesday",
      open_time: "11am",
      close_time: "7pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
    {
      id: 4,
      day_of_week: "Thursday",
      open_time: "8am",
      close_time: "8pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
    {
      id: 5,
      day_of_week: "Friday",
      open_time: "9am",
      close_time: "7pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
    {
      id: 6,
      day_of_week: "Saturday",
      open_time: "11am",
      close_time: "7pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
    {
      id: 7,
      day_of_week: "Sunday",
      open_time: "11am",
      close_time: "6pm",
      subtitle: null,
      description: null,
      created_at: "2022-02-04T03:22:28.000Z",
      updated_at: "2022-02-04T03:22:29.000Z",
    },
  ],
  tags: [
    {
      id: 1,
      platform_id: 1,
      category: "amenity",
      name: "Parking",
    },
    {
      id: 2,
      platform_id: 1,
      category: "amenity",
      name: "Bus Parking",
    },
    {
      id: 3,
      platform_id: 1,
      category: "amenity",
      name: "Washrooms",
    },
    {
      id: 4,
      platform_id: 1,
      category: "amenity",
      name: "Accessible",
    },
  ],
  contents: [],
  images: null,
  hero: getSampleUrl(1),
  carousel_images: [
    getSampleUrl(2),
    getSampleUrl(3),
    getSampleUrl(4),
    getSampleUrl(5),
  ],
  socials: [
    {
      type: "Facebook",
      url: "https://www.facebook.com/UBCgarden/"
    },
    {
      type: "Instagram",
      url: "https://www.instagram.com/ubcgarden/"
    },
    {
      type: "Twitter",
      url: "https://twitter.com/ubcgarden"
    }
  ],
};

export const SAMPLE_CONTENT = {
  title: "About this region",
  description:
    "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
  media: [getSampleUrl(1)]
};

export const SAMPLE_REGION = {
  id: 1,
  name: startCase(region_slugs[0]),
  slug: region_slugs[0],
  hero: getSampleUrl(1),
  description:
    "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
  contents: [],
  lat: 51.50128214079232,
  lng: -0.1418639871964362,
  geofence: [
    { lat: 51.46853473008547, lng: -0.19212031373197602 },
    { lat: 51.497524180512386, lng: -0.21173262604887055 },
    { lat: 51.53055340799247, lng: -0.19907259949857758 },
    { lat: 51.546355594209764, lng: -0.12172620209868867 },
    { lat: 51.521582158763295, lng: -0.05673942383940478 },
    { lat: 51.46495225082477, lng: -0.07553634461577197 },
    { lat: 51.46599494171745, lng: -0.1367465725820871 },
  ],
  carousel_images: [
    getSampleUrl(2),
    getSampleUrl(3),
    getSampleUrl(4),
    getSampleUrl(5),
  ],
  listings: sampleListings(),
};

export const SAMPLE_DMO = {
  id: 1,
  website: 'https://www.example-dmo.com',
  name: startCase(region_slugs[0]),
  description:
    'Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.',
  logo: {
    caption: 'Sample DMO Logo',
    content_type: 'image/png',
    url: 'https://example.com/dmo-logo.png',
  },
};

export const SAMPLE_ITINERARY = {
  id: 1,
  name: "The West Coast",
  slug: "the_west_coast",
  region_slug: region_slugs[0],
  subtitle: "Visit the coast!",
  description:
    "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
  main_content:
    "Maecenas lacus sem, porta sed dolor ac, pellentesque ullamcorper eros. Fusce blandit eleifend accumsan. Sed feugiat, metus sed viverra vestibulum, justo augue dignissim neque, at vehicula metus orci vitae nibh. Quisque accumsan sapien sapien, non semper enim efficitur et. In rhoncus eget velit et euismod. Proin non lacus tristique, blandit enim vel, consequat nulla. Mauris mattis lacus libero, non feugiat erat suscipit id. Pellentesque et tortor ac mi consectetur blandit.",
  hero: getSampleUrl(1),
  contents: [],
  carousel_images: [
    getSampleUrl(2),
    getSampleUrl(3),
    getSampleUrl(4),
    getSampleUrl(5),
  ],
  legs: [{
    id: 168,
    order_on_itin: 1,
    title: "Day One",
    name: "Day One",
    introduction: "Day One",
    stops: [
      {
        id: 1073,
        name: "Lighthouse Park",
        main_type: "stop",
        subtype: null,
        description: "Start your day at Lighthouse Park, a 75-hectare seaside park, and the Lower Mainlands' largest area of rainforest. This park gets its name from the over 100-year-old lighthouse that stands at its southern point. The last standing first-growth Douglas fir forest in Vancouver, Lighthouse Park is the perfect place to enjoy the North Shore's unique vegetation, beaches, and incredible ocean views.",
        position: 1,
        total_position: 1,
        total_stop_number: 1,
        target_type: "Listing",
        listing_type: "non-member",
        lat: 49.331637536985276,
        lng: -123.2635862,
        day_stop_number: 1,
        hero: null,
        listing: {
          id: 1487,
          description: " ",
          short_description: "",
          name: "Lighthouse Park",
          slug: "lighthouse-park",
          city: "West Vancouver",
          region_slug: "metro-vancouver",
          updated_at: "2023-07-05T23:07:51.034Z",
          stakeholder: false,
          lat: 49.331637536985276,
          lng: -123.2635862,
          full_address: "4902 Beacon Ln, West Vancouver, BC, CA, V7W 1K5",
          type: "non-member",
          tags: [],
          location: {
            id: 1487,
            name: "Lighthouse Park",
            lat: 49.331637536985276,
            lng: -123.2635862,
            slug: "lighthouse-park",
            geofence: null,
            short_description: "",
            address: "4902 Beacon Ln, West Vancouver, BC",
            hero: null,
            type: "listing"
          }
        },
        region: null
      }
    ]
  }]
};

export const sampleByType = (type) => {
  if (!type) return {};
  const samples = {
    region: SAMPLE_REGION,
    dmos: SAMPLE_DMO,
    listing: SAMPLE_LISTING,
    itinerary: SAMPLE_ITINERARY,
    content: SAMPLE_CONTENT,
  };
  return samples[type];
};
