import "intersection-observer";
import "isotope-layout";
import trail from "./trail";
import maps from "./maps";
import Flickity from 'flickity';
import "flickity-imagesloaded";
import { flickity_options } from "../constants";
import { compact } from "lodash";
import "./map";
import flatpickr from "flatpickr";
import moment from 'moment';

export const initShared = () => {
  // Fire off the global map init
  maps();
  trail();

  //This function makes icontains case insensitive
  jQuery.expr.pseudos.icontains = function (a, i, m) {
    return jQuery(a).text().toUpperCase().indexOf(m[3].toUpperCase()) >= 0;
  };

  jQuery(function ($) {
    // Initialize flatpickr
    const datePicker = flatpickr("#dateFilter", {
      mode: "range",
      dateFormat: "Y-m-d",
      minDate: "today",
      enableTime: false,
      altInput: true,
      altFormat: "F j, Y",
      onChange: function(selectedDates, dateStr, instance) {
        if (selectedDates && selectedDates.length === 2) {
          const startDate = moment(selectedDates[0]);
          const endDate = moment(selectedDates[1]);

          if (startDate.isValid() && endDate.isValid()) {
            updateUrlAndFilter(startDate, endDate);
          }
        }
      }
    });

    // Handle preset range clicks
    $('.date-preset-ranges button').on('click', function() {
      const range = $(this).data('range');
      const startDate = moment();
      let endDate;

      switch(range) {
        case 'today':
          endDate = moment().endOf('day');
          break;
        case 'week':
          endDate = moment().add(7, 'days');
          break;
        case 'month':
          endDate = moment().add(1, 'month');
          break;
        case '3months':
          endDate = moment().add(3, 'months');
          break;
        default:
          return;
      }

      // Update flatpickr
      datePicker.setDate([startDate.toDate(), endDate.toDate()]);

      // Update URL and filter
      updateUrlAndFilter(startDate, endDate);
    });

    // Helper function to update URL and trigger filter
    function updateUrlAndFilter(startDate, endDate) {
      const urlParams = new URLSearchParams(window.location.search);
      urlParams.set('date-start', startDate.format('YYYY-MM-DD'));
      urlParams.set('date-end', endDate.format('YYYY-MM-DD'));

      const newUrl = window.location.pathname + '?' + urlParams.toString();
      history.pushState(null, '', newUrl);

      doFilter();
    }

    // Add click handler for clear dates button
    $('.clear-dates').on('click', function() {
      // Clear the flatpickr instance
      $("#dateFilter")[0]._flatpickr.clear();

      // Remove date parameters from URL
      const urlParams = new URLSearchParams(window.location.search);
      urlParams.delete('date-start');
      urlParams.delete('date-end');

      // Update URL without date parameters
      const newUrl = window.location.pathname + (urlParams.toString() ? '?' + urlParams.toString() : '');
      history.pushState(null, '', newUrl);

      // Run filter again
      doFilter();
    });

    $(".btn-menu").on("click", function () {
      // Add class to button for animation purposes
      $(this).toggleClass("active");

      // Add class to menu container to reveal menu
      $("body").toggleClass("menu-active");
    });

    $(".btn-it-menu").on("click", function () {
      // Add class to button for animation purposes
      $(this).toggleClass("active");

      // Add class to menu container to reveal menu
      $(".menu-it-drawer").toggleClass("active");
    });

    $(document.body).on(
      "keyup change",
      "#itinSearch, select[data-itin-filter='true']",
      debounce(function () {
        doFilter();
      })
    );

    // Add this event listener to track user changes
    $(document).on('change', 'select[data-itin-filter="true"]', function() {
      $(this).data('user-changed', true);

      // Get current URL parameters
      const urlParams = new URLSearchParams(window.location.search);
      const filterType = $(this).data('itin-filter-type');
      const value = $(this).val();

      // Handle this specific filter's parameter
      if (value) {
        // Update or add this filter's value
        urlParams.set(`filter-${filterType}`, value);
      } else {
        // Remove only this filter's parameter
        urlParams.delete(`filter-${filterType}`);
      }

      // Construct new URL while preserving other parameters
      const newUrl = window.location.pathname + (urlParams.toString() ? '?' + urlParams.toString() : '');
      history.pushState(null, '', newUrl);

      doFilter();
    });

    // Run doFilter on page load
    doFilter();

    function doFilter() {
      const urlParams = new URLSearchParams(window.location.search);
      const search = $("#itinSearch").val();
      const classes = [];

      // Get date filter values using moment
      let dateStart = null;
      let dateEnd = null;

      const dateFilterValue = $("#dateFilter").val();
      // console.log('Date Filter Value:', dateFilterValue);

      if (dateFilterValue) {
        if (dateFilterValue.includes(' to ')) {
          // Handle date range
          const [start, end] = dateFilterValue.split(' to ');
          dateStart = moment(start).startOf('day');
          dateEnd = moment(end).endOf('day');
        } else {
          // Handle single date
          dateStart = moment(dateFilterValue).startOf('day');
          dateEnd = moment(dateFilterValue).endOf('day');
        }
        // console.log('Date Start:', dateStart.format());
        // console.log('Date End:', dateEnd.format());
      }

      $(".searchable-item").each(function () {
        const $item = $(this);
        const eventTitle = $item.find('h2').text().trim();
        const eventTimesStr = $item.attr('data-event-times');
        let eventTimes;

        try {
          eventTimes = eventTimesStr && eventTimesStr.trim() ? JSON.parse(eventTimesStr) : null;
          if (!Array.isArray(eventTimes)) {
            console.error('Invalid event times data structure:', eventTimes);
            eventTimes = null;
          }
        } catch (e) {
          console.error('Failed to parse event times:', eventTimesStr, e);
          eventTimes = null;
        }

        let dateMatch = true;
        if (dateStart && dateEnd && eventTimes) {
          dateMatch = eventTimes.some(eventTime => {
            if (!eventTime.upcoming_times || !Array.isArray(eventTime.upcoming_times)) {
              return false;
            }

            return eventTime.upcoming_times.some(time => {
              const eventStart = moment(time.start).local();
              const eventEnd = moment(time.end).local();

              if (!eventStart.isValid() || !eventEnd.isValid()) {
                console.warn('Invalid date values:', time);
                return false;
              }

              const isSingleDay = dateStart.format('YYYY-MM-DD') === dateEnd.format('YYYY-MM-DD');
              const eventStartDay = eventStart.format('YYYY-MM-DD');
              const dateStartDay = dateStart.format('YYYY-MM-DD');

              let matches;
              if (isSingleDay) {
                matches = eventStartDay === dateStartDay;
              } else {
                matches = (
                  // Event starts during the selected range
                  (eventStart.isSameOrAfter(dateStart, 'day') && eventStart.isSameOrBefore(dateEnd, 'day')) ||
                  // Event ends during the selected range
                  (eventEnd.isSameOrAfter(dateStart, 'day') && eventEnd.isSameOrBefore(dateEnd, 'day')) ||
                  // Event spans the entire selected range
                  (eventStart.isSameOrBefore(dateStart, 'day') && eventEnd.isSameOrAfter(dateEnd, 'day'))
                );
              }

              // console.log('Event Check:', {
              //   title: eventTitle,
              //   isSingleDay,
              //   eventStartDay,
              //   dateStartDay,
              //   matches,
              //   fullEvent: {
              //     start: eventStart.format('YYYY-MM-DD HH:mm:ss Z'),
              //     end: eventEnd.format('YYYY-MM-DD HH:mm:ss Z')
              //   },
              //   filterDates: {
              //     start: dateStart.format('YYYY-MM-DD HH:mm:ss Z'),
              //     end: dateEnd.format('YYYY-MM-DD HH:mm:ss Z')
              //   }
              // });

              return matches;
            });
          });
        }

        if (
          (!search || $item.is(`:icontains('${search}')`)) &&
          (!classes.length || $item.is(classes.map((c) => "." + c).join(""))) &&
          dateMatch
        ) {
          $item.show(200);
        } else {
          $item.hide(200);
        }
      });
    }
    // debounce so filtering doesn't happen every millisecond
    function debounce(fn, threshold = 500) {
      var timeout;
      return function debounced() {
        clearTimeout(timeout);
        var args = arguments;
        var _this = this;
        function delayed() {
          fn.apply(_this, args);
        }
        timeout = setTimeout(delayed, threshold);
      };
    }
    function createFlickity() {
      return new Flickity(".carousel", flickity_options);
    }
    if ($(".carousel").length) {
      const flickity = createFlickity();
      $(".btn-previous").on("click", function () {
        // flickity( ‘previous’, isWrapped, isInstant )
        flickity.previous();
      });
      $(".btn-next").on("click", function () {
        flickity.next();
      });
    }
  });
};
