import { createRef, useRef } from "@wordpress/element";
import { Map as MapBlock, Edit } from "../editor_blocks/common";

let attributes;
window.itinMaps = {};
jQuery(function ($) {
  $(".itinerator-map-container.itin").each((_, map) => {
    attributes = $(map).data("itin-attributes");
    const recordId = $(map).data("itin-record-id");
    const container = map;
    const root = ReactDOM.createRoot(container);
    root.render(<Map attributes={{ ...attributes, recordId }} />);
  });
});

const Map = ({ attributes }) => {
  const ref = useRef();
  return (
    <Edit attributes={attributes}>
      <MapBlock ref={ref} />
    </Edit>
  );
};
