/**
 * Maps Common
 */

const { googleMapsMapId } = itineratorGlobal;

export default () => {
  jQuery(function ($) {
    const $map = jQuery(".google-map").first(); // Only does one map per page
    const $markers = $map.find(".marker");
    window.map = null
    window.map_container = $map
    window.markers = $markers
    window.markers_array = []
    window.mapbounds_array = []


    if ($map.length > 0) {
      if (!(typeof window.google === "object" && window.google.maps)) {
        console.log('3. Error: Google Maps API not loaded');
      } else {
        const CustomMarker = function (options) {
          // Initialize all properties.
          this.position = options.position ? options.position : null;
          this.visible = options.visible ? options.visible : true;
          this.title = options.title ? options.title : "";
          this.map = options.map ? options.map : null;
          this.html = options.html ? options.html : "";
          this.part = options.part ? options.part : 0;
          this.poiIndex = options.poiIndex ? options.poiIndex : 0;
          this.zIndex = options.zIndex ? options.zIndex : 100;
          this.anchorPoint = new window.google.maps.Point(0, 0);
          (this.ne = options.ne || null), (this.radius = 0);

          this.div = null;

          this.setMap(this.map);
        };

        CustomMarker.prototype = new window.google.maps.OverlayView();

        CustomMarker.prototype.onAdd = function () {
          // Create the div if it doesn't exist already
          if (!this.div) {
            this.div = document.createElement("div");
            this.div.style.position = "absolute";
            this.div.style.zIndex = this.zIndex;
            this.div.style.visibility = this.visible ? "visible" : "hidden";
            this.div.title = this.title;
            this.div.classList.add("poi-marker");

            if (this.html) {
              this.div.innerHTML = this.html;
            }

            const that = this;
            this.div.addEventListener("click", function (e) {
              if (
                navigator.userAgent.toLowerCase().indexOf("msie") !== -1 &&
                document.all
              ) {
                event.cancelBubble = true;
                event.returnValue = false;
              } else {
                event.stopPropagation();
              }

              window.google.maps.event.trigger(that, "click", e);
            });

            this.div.addEventListener("mouseover", function (e) {
              window.google.maps.event.trigger(that, "mouseover", e);
            });

            this.div.addEventListener("mouseout", function (e) {
              window.google.maps.event.trigger(that, "mouseout", e);
            });
          }

          const panes = this.getPanes();
          panes.overlayMouseTarget.appendChild(this.div);

          window.google.maps.event.trigger(this, "ready");
        };

        CustomMarker.prototype.draw = function () {
          const point = this.getProjection().fromLatLngToDivPixel(
            this.position
          );

          // if (this.ne) {
          //   let outerPoint = this.getProjection().fromLatLngToDivPixel(this.ne);
          //   this.radius = Math.abs(outerPoint.x - point.x);

          //   $(this.div).find('.marker-circle').css({'padding': this.radius * 2});
          // }

          if (point) {
            const markerHeight = this.div.clientHeight;
            const markerWidth = this.div.clientWidth;

            this.anchorPoint = new window.google.maps.Point(
              0,
              -(markerHeight / 1.5)
            );

            this.div.style.top = point.y - markerHeight / 2 + "px";
            this.div.style.left = point.x - markerWidth / 2 + "px";
          }
        };

        CustomMarker.prototype.onRemove = function () {
          if (this.div) {
            this.div.parentNode.removeChild(this.div);
          }
        };

        CustomMarker.prototype.getPosition = function () {
          return this.position;
        };

        CustomMarker.prototype.setVisible = function (visible) {
          if (this.div) {
            // The visibility property must be a string enclosed in quotes.
            this.div.style.visibility = visible ? "visible" : "hidden";
          }
        };

        CustomMarker.prototype.getVisible = function () {
          if (this.div) {
            if (this.div.style.visibility === "visible") {
              return true;
            }
          }

          return false;
        };

        CustomMarker.prototype.getDraggable = function () {
          return false;
        };

        CustomMarker.prototype.getAnchorPoint = function () {
          return this.anchorPoint;
        };

        const removeHoverClass = function () {
          $.each(window.markers_array, function (i, marker) {
            $(marker.div).removeClass("hover");
          });
        };

        // Generic BC Fallback
        let center = new window.google.maps.LatLng(52.054971, -121.628607);

        // Use the first marker as the initial centre
        if ($markers.length > 0) {
          center = new window.google.maps.LatLng(
            $markers.eq(0).data("lat"),
            $markers.eq(0).data("lng")
          );
        }

        // Create the map
        map = new window.google.maps.Map($map[0], {
          zoom: parseInt($map.data("zoom"), 10) || 15,
          center: center,
          fullscreenControl: false,
          mapTypeControl: false,
          rotateControl: false,
          streetViewControl: false,
          scaleControl: false,
          mapId: googleMapsMapId || undefined,
        });

        if ($markers.length > 0) {
          // Make the infowindow for this map
          const infoWindow = new window.google.maps.InfoWindow({
            maxWidth: 260,
          });

          infoWindow.addListener("closeclick", removeHoverClass);

          map.addListener("click", function () {
            infoWindow.close();
            removeHoverClass();
          });

          // The 0th item is all markers
          window.mapbounds_array[0] = new window.google.maps.LatLngBounds();

          // Process markers
          $markers.each(function (markerIndex) {
            const $marker = $(this);

            const markerArgs = {
              position: new window.google.maps.LatLng(
                $marker.data("lat"),
                $marker.data("lng")
              ),
              zIndex: $marker.data("z-index")
                ? $marker.data("z-index")
                : -parseInt($marker.data("lat") * 100000),
              map: $marker.data("hide") ? null : map,
              title: $marker.data("title"),
              part: $marker.data("part"),
              poiIndex: $marker.data("poi-index"),
              // ne: $marker.data('circle') ? new window.google.maps.LatLng(
              //   $marker.data('ne-lat'),
              //   $marker.data('ne-lng')
              // ) : null,
            };

            if ($marker.find("[data-marker]").length > 0) {
              markerArgs.html = $marker.find("[data-marker]").html();
              window.markers_array[markerIndex] = new CustomMarker(markerArgs);
            } else {
              window.markers_array[markerIndex] = new window.google.maps.Marker(
                markerArgs
              );
            }

            // Extend Bounds
            window.mapbounds_array[0].extend(window.markers_array[markerIndex].position);

            // If there's content, put it in the infowindow
            if ($.trim($marker.find("[data-infowindow]").html()).length > 0) {
              if (markerIndex === 0) {
                infoWindow.setContent($marker.find("[data-infowindow]").html());

                if ($marker.data("open")) {
                  infoWindow.open(map, window.markers_array[markerIndex]);
                }
              }

              window.markers_array[markerIndex].addListener("click", function () {
                infoWindow.setContent($marker.find("[data-infowindow]").html());
                infoWindow.open(map, window.markers_array[markerIndex]);
              });
            }
          });

          window.google.maps.event.addListenerOnce(
            map,
            "bounds_changed",
            function (event) {
              map.setZoom(Math.min(13, map.getZoom()));
            }
          );

          // Fit map to bounds and centre
          if (window.markers_array.length === 1) {
            map.setCenter(window.mapbounds_array[0].getCenter());
          } else if (window.markers_array.length > 1) {
            map.fitBounds(window.mapbounds_array[0]);
            map.panToBounds(window.mapbounds_array[0]);
          }
        }
      }
    }
  });
};
