/**
 * Trail
 */
import 'intersection-observer';
import Stickyfill from 'stickyfilljs';
import scrollama from 'scrollama';
import { throttle } from 'lodash';


export default () => {
  jQuery(function ($) {
    const $map = window.map_container
    const map = window.map
    const markersArr = window.markers_array
    const mapBoundsArr = window.mapbounds_array

    const scroller = scrollama();
    let currentPart = 0;

    const handleResize = function () {
      $map.height(window.innerHeight);
      scroller.resize();
    };

    const setupScrollingMap = function () {
      Stickyfill.add($(".sticky-top"));

      scroller
        .setup({
          step: ".group-start",
          // debug: true,
        })
        .onStepEnter(function (response) {
          // Set current part for mobile tab switching
          currentPart = response.index + 1;

          // Fit to bounds of this part
          fitToPart(currentPart);

          // Show/Hide Markers
          showHideMarkers(currentPart);
        })
        .onStepExit(function (response) {
          // Set current part for mobile tab switching
          currentPart = response.index + 1;

          // When leaving the itinerary at the top or the bottom, fit and show all markers again
          var partsCount = $(".group-start[data-scrollama-index]").length;

          if (
            (response.index === 0 && response.direction === "up") ||
            (response.index === partsCount - 1 && response.direction === "down")
          ) {
            currentPart = 0;
            fitToPart(currentPart);

            // Show all markers
            $.each(markersArr, function (i, marker) {
              marker.setVisible(true);
            });
          }
        });

      handleResize();
      $(window).on("resize", throttle(handleResize, 500));
    };

    const showHideMarkers = function (part) {
      // var hideMarkers = activePolyline.get('hideOtherMarkers');
      const hideMarkers = true;

      if (hideMarkers) {
        $.each(markersArr, function (i, marker) {
          if (marker.part !== part) {
            marker.setVisible(false);
          } else {
            marker.setVisible(true);
          }
        });
      } else {
        $.each(markersArr, function (i, marker) {
          marker.setVisible(true);
        });
      }
    };

    const fitToPart = function (part) {
      // Calculate bounds if we hadn't already stored it
      if (mapBoundsArr[part] === undefined) {
        mapBoundsArr[part] = new window.google.maps.LatLngBounds();

        $.each(markersArr, function (i, marker) {
          if (marker.part === part) {
            mapBoundsArr[part].extend(marker.getPosition());
          }
        });
      }

      // If these bounds are empty, fall back to the global all-markers bounds
      if (mapBoundsArr[part].isEmpty()) {
        part = 0;
      }

      map.fitBounds(mapBoundsArr[part]);
      map.panToBounds(mapBoundsArr[part]);
    };

    if (map) {
      setupScrollingMap();

      $(".itinerary-content [data-poi-index]").on("mouseenter", function () {
        const $poi = $(this);
        const poiIndex = $poi.data("poi-index");

        if (poiIndex) {
          $.each(markersArr, function (i, marker) {
            if (marker.poiIndex == poiIndex) {
              $(marker.div).addClass("hover");
              window.google.maps.event.trigger(marker, "click");
            } else {
              $(marker.div).removeClass("hover");
            }
          });
        }
      });
    }
    var $itinerary = $("#itinerary");
    let itineraryScrollPosition =
      !!$itinerary.length && $itinerary.offset().top;

    // When switching tabs, trigger a Google maps resize event, and then fit to bounds again,
    // as fit to bounds only actually works when the map viewport isn't display: none
    $('.section-itinerary a[data-toggle="pill"]').on(
      "shown.bs.tab",
      function (e) {
        // Only show the inactive tab
        $(".section-itinerary li.nav-item").toggleClass("d-none");

        if (e.target.id === "map-tab") {
          $(window).scrollTop($("#map").offset().top);
          if (map) {
            window.google.maps.event.trigger(map, "resize");
            map.setZoom(Math.min(14, map.getZoom()));

            // Zoom to show all parts
            fitToPart(currentPart);
          }
        } else {
          $(window).scrollTop(itineraryScrollPosition);
        }
      }
    );

    // Using the hide event to make sure we capture this before anything moves
    $('.section-itinerary a[data-toggle="pill"]').on(
      "hide.bs.tab",
      function (e) {
        if (e.target.id === "itinerary-tab") {
          itineraryScrollPosition = $(window).scrollTop();
        }
      }
    );

    // Collapse the nav menu when clicking a link
    $(".page-nav-row .nav-link").on("click", function () {
      $("#pageNavMenu").collapse("hide");
    });
  });
}
