<div class="itin itinerator-challenges <?= $this->attributes['align'] ? 'align' . $this->attributes['align'] : ''; ?> <?= $this->attributes['className'] ?? ''; ?>">
    <div class="container-fluid">
        <?php if (empty($this->challenges) && !$this->loading) : ?>
            <p>No Challenges found</p>
        <?php endif; ?>
        <?php foreach ($this->challenges as $challenge) : ?>
            <div class="challenge-row row justify-content-end align-items-center searchable-item mb-4 <?= $challenge->slug ?> <?= implode(' ', array_map(function ($tag) { return 'tag-id-' . $tag->tag_id; }, $challenge->tags)) ?>">
                <div class="col-12 col-md-6 order-md-2 p-0 open-half">
                    <?php if ($this->attributes['showImage'] && $challenge->hero) : ?>
                        <div class="image">
                            <img src="<?= $challenge->hero->url ?>" class="img-fluid" />
                        </div>
                    <?php endif; ?>
                    <a href="/challenge/<?php $challenge->slug ?>" class="stretched-link"></a>
                </div>
                <div class="col-12 col-md-6 order-md-1 contained-half">
                    <div class="content">
                        <?php if ($this->attributes['showName'] && $challenge->name) : ?>
                            <h2><?= $challenge->name ?></h2>
                        <?php endif; ?>
                        <?php if ($this->attributes['showLocation'] && $challenge->target_name) : ?>
                            <h3><?= $challenge->target_name ?></h3>
                        <?php endif; ?>
                        <?php if ($this->attributes['showDates'] && $challenge->rewards) : ?>
                            <?php foreach ($challenge->rewards as $reward) : ?>
                                <div><?= $reward->date_string ?></div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        <?php if ($this->attributes['showDescription'] && $challenge->description) : ?>
                            <div><?= $challenge->description ?></div>
                        <?php endif; ?>
                        <?php if ($this->attributes['showName'] && $challenge->name) : ?>
                            <a href="/challenge/<?= $challenge->slug; ?>" class="btn btn-primary" aria-label="<?= 'Explore ' . $challenge->name ?>">
                                <span><?= $this->attributes['buttonText'] ?></span> <?= $challenge->name ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
