<?php $counter = 1; // Initialize a counter variable
$platform_logo_border_radius = $this->attributes['platformLogoBorderRadius'] ?? null;
$overlay_border_radius = $this->attributes['overlayBorderRadius'] ?? null;
$grid_item_border_radius = $this->attributes['gridItemBorderRadius'] ?? null;
$grid_gap = $this->attributes['gridGap'] ?? null;
$align_class = $this->attributes['align'] ?? null;

?>

<div class="itin wp-block-group itinerator-dmo-itineraries-carousel">

  <?php if (!empty($this->dmo_itineraries)) : ?>
    <div class="section-carousel alignfull itinerator-listing itinerator-slider">
      <div class="carousel-nav container">
        <button class="btn-carousel btn-previous">Previous</button>
        <button class="btn-carousel btn-next">Next</button>
      </div>
      <div class="container-fluid">
        <div class="carousel">
          <?php foreach ($this->dmo_itineraries as $itinerary) : ?>
            <?php if ($itinerary->status === 'active') : ?>
              <?php
              $primary_url = $itinerary->primary_url;
              // Add http if missing
              if (!preg_match('#^https?://#', $primary_url) && !empty($primary_url)) {
                $primary_url = 'https://' . $primary_url;
              }
              $platform_url = $itinerary->platform_url;
              // Add http if missing
              if (!preg_match('#^https?://#', $platform_url) && !empty($platform_url)) {
                $platform_url = 'https://' . $platform_url;
              }
              $itinerary_subtitle = ($itinerary->subtitle == null || $itinerary->subtitle == '' || $itinerary->subtitle == "Itinerary") ? "Discover more about this itinerary." : $itinerary->subtitle;
              ?>
              <div class="carousel-cell" style="background-image: url('<?php echo isset($itinerary->hero->url) ? $itinerary->hero->url : ''; ?>'); border-radius: <?php echo $grid_item_border_radius ?>; margin: 0 <?php echo $grid_gap ?>;">
                <!-- Setting background image -->

                <!-- Logo at the top -->
                <div class="platform-logo" style="text-align:center">
                  <?php if (!empty($itinerary->platform_logo->url)) : ?>

                    <a href="<?php echo $platform_url ?>" class="">
                      <img src="<?php echo $itinerary->platform_logo->url; ?>" alt="" style="border-radius: <?php echo $platform_logo_border_radius ?>" />
                    </a>
                  <?php endif; ?>
                </div>
                <div class="overlay-content" style="border-radius: <?php echo $overlay_border_radius ?>; margin-top:100px">
                  <!-- Details at the bottom -->
                  <div class="itinerary-details">
                    <a href="<?php echo isset($primary_url) ? $primary_url : $platform_url ?>" class="">
                      <h2><?php echo $itinerary_subtitle ?></h2>
                      <!-- <h4><?php echo $itinerary->platform_name ?></h4> -->
                    </a>
                    <!-- <h4><?php echo $itinerary->platform_name ?></h4> -->
                    <p><?php echo $itinerary->stop_count . ' Stops, ' . $itinerary->leg_count . ' ' . ($itinerary->leg_count > 1. ? ' Days' : 'Day') ?></p>

                  </div>
                </div>

              </div>
            <?php endif; ?>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

</div>
