<?php
$columns = ($this->columns === 'auto') ? count($this->dmo_itineraries) : $this->columns;
$platform_logo_border_radius = $this->attributes['platformLogoBorderRadius'] ?? null;
$overlay_border_radius = $this->attributes['overlayBorderRadius'] ?? null;
$grid_item_border_radius = $this->attributes['gridItemBorderRadius'] ?? null;
$grid_gap = $this->attributes['gridGap'] ?? null;
$align_class = $this->attributes['align'] ?? null;

?>
<style type="text/css">
  .itinerator-dmo-itineraries-grid .grid-container {
    grid-template-columns: repeat(<?php echo $columns; ?>, minmax(250px, 1fr));
    gap: <?php echo $grid_gap; ?>;
    row-gap: <?php echo $grid_gap; ?>;
  }
</style>

<div class="itin itinerator-dmo-itineraries-grid">
  <div class="grid-container align<?= $align_class; ?>">
    <?php foreach ($this->dmo_itineraries as $itinerary) : ?>
      <?php if ($itinerary->status === 'active') : ?>
        <?php
        $primary_url = $itinerary->primary_url;
        // Add http if missing
        if (!preg_match('#^https?://#', $primary_url) && !empty($primary_url)) {
          $primary_url = 'https://' . $primary_url;
        }
        $platform_url = $itinerary->platform_url;
        // Add http if missing
        if (!preg_match('#^https?://#', $platform_url) && !empty($platform_url)) {
          $platform_url = 'https://' . $platform_url;
        }
        $itinerary_subtitle = ($itinerary->subtitle == null || $itinerary->subtitle == '' || $itinerary->subtitle == "Itinerary") ? "Discover more about this itinerary." : $itinerary->subtitle;
        ?>
        <div class="item">
          <!-- Setting background image -->
          <div class="platform-logo">
            <?php if (isset($itinerary->platform_logo) && $itinerary->platform_logo->url) : ?>

              <a href="<?php echo $platform_url; ?>" class="">
                <img src="<?php echo $itinerary->platform_logo->url; ?>" alt="" style="border-radius: <?php echo $platform_logo_border_radius; ?>" />
              </a>
            <?php endif; ?>
          </div>
          <?php if (isset($itinerary->hero) && $itinerary->hero->url) : ?>
            <figure style="background-image: url('<?php echo $itinerary->hero->url; ?>'); border-radius: <?php echo $grid_item_border_radius; ?>">
              <div class="overlay-content" style="border-radius: <?php echo $overlay_border_radius; ?>">
                <!-- Logo at the top -->
                <!-- Details at the bottom -->
                <div class="itinerary-details">
                  <a href="<?php echo isset($primary_url) ? $primary_url : $platform_url; ?>" class="">
                    <h2><?php echo $itinerary_subtitle; ?></h2>
                    <!-- <h4><?php echo $itinerary->platform_name; ?></h4> -->
                  </a>
                  <p><span class="icon dashicon dashicons dashicons-location-alt" style="margin: 3px 5px 0 0;"></span><?php echo $itinerary->stop_count . ' Stops, ' . '<span class="icon dashicon dashicons dashicons-calendar" style="margin: 3px 5px 0 10px;"></span>' . $itinerary->leg_count . ' ' . ($itinerary->leg_count > 1. ? ' Days' : 'Day'); ?></p>
                  <p class="" style="line-height:1.3"><?php echo $itinerary->main_content; ?></p>
                </div>
              </div>
            </figure>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    <?php endforeach; ?>
  </div>
</div>
