<?php
$counter = 1; // Initialize a counter variable

// Get the number of columns or if set to 'auto' count the number of DMOs and use that
$columns = ($this->columns === 'auto') ? count((array) $this->dmos) : $this->columns;
$columns = ($columns > 5) ? 4 : $columns;
$column_width = ($columns < 4 && $this->columns === 'auto') ? 3 : floor(12 / $columns);
?>

<?php if (is_array($this->dmos) && !empty($this->dmos)) : ?>
  <div class="itin itinerator-dmos <?= $this->attributes['align'] ? 'align' . $this->attributes['align'] : ''; ?> <?= $this->attributes['className'] ?? ''; ?>">
    <div class="row g-4">
      <?php foreach ($this->dmos as $dmo) : // Loop through the list of dmos ?>
        <div class="col-12 col-md-<?php echo $column_width ?> mb-4" id="<?php echo $dmo->slug ?>">
          <div class="card h-100 p-0">
            <?php if (isset($dmo->logo) && !empty($dmo->logo->url)) : ?>
              <div class="card-img-top dmos-image-container text-center">
                <img class="img-fluid dmos-image" src="<?php echo $dmo->logo->url; ?>" alt="" />
              </div>
            <?php endif; ?>
            <div class="card-body dmos-content">
              <h4 class="card-title dmo-name text-center">
                <a href="<?php echo $dmo->website; ?>"><?php echo $dmo->name; ?></a>
              </h4>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
<?php endif; ?>
