<?php

?>

<?php
$event = $this->event;
$next_event = \Itinerator\Templates\Events::getNextEventTime($event->event_times);
$is_series = \Itinerator\Templates\Events::isSeries($event);
?>

<div class="itin itinerator-event alignfull" style="margin: 5rem 0;">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-6">
        <div class="mb-3">
          <?php if (isset($event->hero)) : ?>
            <?= $event->hero->getMedia('medium', 'img-fluid rounded-3 bg-light'); ?>
          <?php endif; ?>
        </div>
      </div>

      <div class="col-12 col-lg-6">
        <?php if ($event->featured) : ?>
          <div class="featured-event text-secondary">
            <i class="fas fa-star"></i> <strong>Featured</strong>
          </div>
        <?php endif; ?>

        <h1 class="mb-3"><?php echo $event->name; ?></h1>

        <?php if (isset($event->cost)): ?>
          <div class="event-cost mt-1 mb-3 small">
            <?php
            $cost = trim($event->cost);
            if ($cost === "0" || strtolower($cost) === "free") {
              echo "Free";
            } elseif (is_numeric($cost)) {
              echo "<strong>Cost:</strong> $" . $cost;
            } else {
              echo $cost;
            }
            ?>
          </div>
        <?php endif; ?>


        <?php if (isset($event->event_times)) : ?>
          <div class="event-datetimes fs-5 mb-3">
            <?php if ($next_event && $datetimes = \Itinerator\Templates\Events::convertDateTimeRange($next_event->next_start, $next_event->next_end)) : ?>
              <div class="event-datetime">
                <div class="d-flex gap-2">
                  <div class="event-date-range">
                    <strong>Next Event:</strong> <?= $datetimes['date_range']; ?>
                    <?php if ($is_series) : ?>
                      <span class="fa fa-calendar" aria-hidden="true" title="This is part of a series"></span>
                    <?php endif; ?>
                  </div>
                  <div class="border-start border-dark mx-1"></div>
                  <div class="event-time-range">
                    <?= !$next_event->all_day ? $datetimes['time_range'] : 'All Day'; ?>
                  </div>
                </div>

                <?php if (!empty($next_event->locations)) : ?>
                  <?php foreach ($next_event->locations as $location) : ?>
                    <div class="event-location small mt-2">
                      <address><i class="fa fa-map-marker-alt"></i> <strong><?= $location->name; ?></strong>,
                        <?= $location->full_address; ?></address>
                    </div>
                  <?php endforeach; ?>
                <?php endif; ?>
              </div>

              <?php if ($is_series) : ?>
                <div class="mt-3">
                  <button class="btn btn-outline-secondary btn-sm mb-3" type="button" data-toggle="collapse" data-target="#eventTimes" aria-expanded="false" aria-controls="eventTimes">
                    See more event times
                  </button>
                  <div class="collapse mt-2" id="eventTimes">
                    <div class="card card-body">
                      <?php
                      $occurrences = \Itinerator\Templates\Events::getRecurringEventOccurrences($event->event_times, 10);
                      if (!empty($occurrences)) :
                      ?>
                        <strong>Upcoming dates:</strong>
                        <ul class="list-unstyled mb-0">
                          <?php foreach ($occurrences as $occurrence) : ?>
                            <li class="mb-2">
                              <div><?= $occurrence['start'] ?> - <?= $occurrence['time'] ?></div>
                              <?php if (!empty($occurrence['locations'])) : ?>
                                <?php foreach ($occurrence['locations'] as $location) : ?>
                                  <div class="event-location small ms-3">
                                    <address><i class="fa fa-map-marker-alt"></i> <strong><?= $location->name; ?></strong>,
                                      <?= $location->full_address; ?></address>
                                  </div>
                                <?php endforeach; ?>
                              <?php endif; ?>
                            </li>
                          <?php endforeach; ?>
                        </ul>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <?php if (isset($event->description)) : ?>
          <div class="event-description mb-4">
            <?= $this->parse_markdown($event->description); ?>
          </div>
        <?php endif; ?>

        <div class="event-links">
          <?php if ($event->ticket_url) : ?>
            <a href="<?= $event->ticket_url; ?>/" target="_blank" class="btn btn-sm btn-primary">Get Tickets</a>
          <?php endif; ?>

          <?php if ($event->website) : ?>
            <a href="<?= $event->website; ?>" target="_blank" class="btn btn-sm btn-primary">Website</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
