<div class="itin itinerator-events alignfull">
  <div class="container">
    <?php if (empty($this->events)) : ?>
      <div class="row">
        <div class="col-12 py-5">
          <p class="fs-4">There are no events listed at this time. Watch this space for future events listings.</p>
        </div>
      </div>
    <?php else : ?>
      <!-- Date range selector -->
      <?php if (isset($this->attributes['showDateFilter']) && $this->attributes['showDateFilter'] === true) : ?>
        <div class="event-filters mb-4">
        <div class="filters mb-4">
            <div class="date-filter-wrapper" style="display: flex;
            flex-direction: row; align-items: stretch; gap: 0.5rem;">
              <input type="text" id="dateFilter" class="form-control"
              placeholder="Select dates...">
              <button type="button" class="btn btn-secondary clear-dates">Clear
              Dates</button>
              <div class="date-preset-ranges mb-3" style="display: contents;">
                <button type="button" class="btn btn-secondary"
                data-range="today">Today</button>
                <button type="button" class="btn btn-secondary"
                data-range="week">Next 7 Days</button>
                <button type="button" class="btn btn-secondary"
                data-range="month">Next Month</button>
                <button type="button" class="btn btn-secondary"
                data-range="3months">Next 3 Months</button>
              </div>
            </div>
          </div>
          <hr>
        </div>
      <?php endif; ?>

      <div class="row gy-3 mb-5">
        <?php
        $events = $this->events;
        usort($events, function ($a, $b) {
          // First sort by featured status
          $featuredDiff = ($b->featured ? 1 : 0) - ($a->featured ? 1 : 0);
          if ($featuredDiff !== 0) {
            return $featuredDiff;
          }

          // Then sort by start time
          $aStart = $a->event_times[0]->next_start ?? null;
          $bStart = $b->event_times[0]->next_start ?? null;

          if ($aStart === $bStart) {
            return 0;
          }
          return $aStart < $bStart ? -1 : 1;
        });
        ?>
        <?php foreach ($events as $event) : ?>
          <?php
          $eventTimes = $event->event_times[0];
          $start_date = $this->convertToWpTimezone($eventTimes->next_start);
          $end_date = $this->convertToWpTimezone($eventTimes->next_end);

          $is_recurring = $this->isRecurring($event);
          $occurrences = $is_recurring ? $this->getRecurringEventOccurrences($event->event_times) : [];
          ?>
          <?php include('partials/event-card.php'); ?>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
